/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.HighFrequencyDictionary;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.AbstractLuceneSpellChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexBasedSpellChecker
extends AbstractLuceneSpellChecker {
    private static final Logger log = LoggerFactory.getLogger(IndexBasedSpellChecker.class);
    public static final String THRESHOLD_TOKEN_FREQUENCY = "thresholdTokenFrequency";
    protected float threshold;
    protected IndexReader reader;

    @Override
    public String init(NamedList config, SolrCore core) {
        super.init(config, core);
        this.threshold = config.get(THRESHOLD_TOKEN_FREQUENCY) == null ? 0.0f : ((Float)config.get(THRESHOLD_TOKEN_FREQUENCY)).floatValue();
        this.initSourceReader();
        return this.name;
    }

    private void initSourceReader() {
        if (this.sourceLocation != null) {
            try {
                FSDirectory luceneIndexDir = FSDirectory.open((File)new File(this.sourceLocation));
                this.reader = DirectoryReader.open((Directory)luceneIndexDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void build(SolrCore core, SolrIndexSearcher searcher) {
        Object reader = null;
        try {
            reader = this.sourceLocation == null ? searcher.getIndexReader() : this.reader;
            this.dictionary = new HighFrequencyDictionary((IndexReader)reader, this.field, this.threshold);
            this.spellChecker.clearIndex();
            this.spellChecker.indexDictionary(this.dictionary, new IndexWriterConfig(core.getSolrConfig().luceneMatchVersion, null), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IndexReader determineReader(IndexReader reader) {
        IndexReader result = null;
        result = this.sourceLocation != null ? this.reader : reader;
        return result;
    }

    @Override
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        super.reload(core, searcher);
        this.initSourceReader();
    }

    public float getThreshold() {
        return this.threshold;
    }
}

