/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordFrequencyComparator;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSolrSpellChecker
extends SolrSpellChecker {
    private static final Logger LOG = LoggerFactory.getLogger(DirectSolrSpellChecker.class);
    public static final String COMPARATOR_CLASS = "comparatorClass";
    public static final String SCORE_COMP = "score";
    public static final String FREQ_COMP = "freq";
    public static final String STRING_DISTANCE = "distanceMeasure";
    public static final String ACCURACY = "accuracy";
    public static final String THRESHOLD_TOKEN_FREQUENCY = "thresholdTokenFrequency";
    public static final String INTERNAL_DISTANCE = "internal";
    public static final float DEFAULT_ACCURACY = 0.5f;
    public static final float DEFAULT_THRESHOLD_TOKEN_FREQUENCY = 0.0f;
    public static final String MAXEDITS = "maxEdits";
    public static final int DEFAULT_MAXEDITS = 2;
    public static final String MINPREFIX = "minPrefix";
    public static final int DEFAULT_MINPREFIX = 1;
    public static final String MAXINSPECTIONS = "maxInspections";
    public static final int DEFAULT_MAXINSPECTIONS = 5;
    public static final String MINQUERYLENGTH = "minQueryLength";
    public static final int DEFAULT_MINQUERYLENGTH = 4;
    public static final String MAXQUERYFREQUENCY = "maxQueryFrequency";
    public static final float DEFAULT_MAXQUERYFREQUENCY = 0.01f;
    private DirectSpellChecker checker = new DirectSpellChecker();

    @Override
    public String init(NamedList config, SolrCore core) {
        LOG.info("init: " + config);
        String name = super.init(config, core);
        Object comp = SuggestWordQueue.DEFAULT_COMPARATOR;
        String compClass = (String)config.get(COMPARATOR_CLASS);
        if (compClass != null) {
            comp = compClass.equalsIgnoreCase(SCORE_COMP) ? SuggestWordQueue.DEFAULT_COMPARATOR : (compClass.equalsIgnoreCase(FREQ_COMP) ? new SuggestWordFrequencyComparator() : core.getResourceLoader().newInstance(compClass, Comparator.class, new String[0]));
        }
        StringDistance sd = DirectSpellChecker.INTERNAL_LEVENSHTEIN;
        String distClass = (String)config.get(STRING_DISTANCE);
        if (distClass != null && !distClass.equalsIgnoreCase(INTERNAL_DISTANCE)) {
            sd = core.getResourceLoader().newInstance(distClass, StringDistance.class, new String[0]);
        }
        float minAccuracy = 0.5f;
        Float accuracy = (Float)config.get(ACCURACY);
        if (accuracy != null) {
            minAccuracy = accuracy.floatValue();
        }
        int maxEdits = 2;
        Integer edits = (Integer)config.get(MAXEDITS);
        if (edits != null) {
            maxEdits = edits;
        }
        int minPrefix = 1;
        Integer prefix = (Integer)config.get(MINPREFIX);
        if (prefix != null) {
            minPrefix = prefix;
        }
        int maxInspections = 5;
        Integer inspections = (Integer)config.get(MAXINSPECTIONS);
        if (inspections != null) {
            maxInspections = inspections;
        }
        float minThreshold = 0.0f;
        Float threshold = (Float)config.get(THRESHOLD_TOKEN_FREQUENCY);
        if (threshold != null) {
            minThreshold = threshold.floatValue();
        }
        int minQueryLength = 4;
        Integer queryLength = (Integer)config.get(MINQUERYLENGTH);
        if (queryLength != null) {
            minQueryLength = queryLength;
        }
        float maxQueryFrequency = 0.01f;
        Float queryFreq = (Float)config.get(MAXQUERYFREQUENCY);
        if (queryFreq != null) {
            maxQueryFrequency = queryFreq.floatValue();
        }
        this.checker.setComparator((Comparator)comp);
        this.checker.setDistance(sd);
        this.checker.setMaxEdits(maxEdits);
        this.checker.setMinPrefix(minPrefix);
        this.checker.setAccuracy(minAccuracy);
        this.checker.setThresholdFrequency(minThreshold);
        this.checker.setMaxInspections(maxInspections);
        this.checker.setMinQueryLength(minQueryLength);
        this.checker.setMaxQueryFrequency(maxQueryFrequency);
        this.checker.setLowerCaseTerms(false);
        return name;
    }

    @Override
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
    }

    @Override
    public void build(SolrCore core, SolrIndexSearcher searcher) {
    }

    @Override
    public SpellingResult getSuggestions(SpellingOptions options) throws IOException {
        LOG.debug("getSuggestions: " + options.tokens);
        SpellingResult result = new SpellingResult();
        float accuracy = options.accuracy == Float.MIN_VALUE ? this.checker.getAccuracy() : options.accuracy;
        for (Token token : options.tokens) {
            String tokenText = token.toString();
            Term term = new Term(this.field, tokenText);
            int freq = options.reader.docFreq(term);
            int count = options.alternativeTermCount != null && freq > 0 ? options.alternativeTermCount : options.count;
            SuggestWord[] suggestions = this.checker.suggestSimilar(term, count, options.reader, options.suggestMode, accuracy);
            result.addFrequency(token, freq);
            if (options.alternativeTermCount != null && freq > 0) {
                boolean foundOriginal = false;
                SuggestWord[] suggestionsWithOrig = new SuggestWord[suggestions.length + 1];
                for (int i = 0; i < suggestions.length; ++i) {
                    if (suggestions[i].string.equals(tokenText)) {
                        foundOriginal = true;
                        break;
                    }
                    suggestionsWithOrig[i + 1] = suggestions[i];
                }
                if (!foundOriginal) {
                    SuggestWord orig = new SuggestWord();
                    orig.freq = freq;
                    orig.string = tokenText;
                    suggestionsWithOrig[0] = orig;
                    suggestions = suggestionsWithOrig;
                }
            }
            if (suggestions.length == 0 && freq == 0) {
                List<String> empty = Collections.emptyList();
                result.add(token, empty);
                continue;
            }
            for (SuggestWord suggestion : suggestions) {
                result.add(token, suggestion.string, suggestion.freq);
            }
        }
        return result;
    }

    @Override
    public float getAccuracy() {
        return this.checker.getAccuracy();
    }

    @Override
    public StringDistance getStringDistance() {
        return this.checker.getDistance();
    }
}

