/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.servlet.MultipartRequestParser;
import org.apache.solr.servlet.RawRequestParser;
import org.apache.solr.servlet.SimpleRequestParser;
import org.apache.solr.servlet.SolrRequestParser;
import org.apache.solr.servlet.StandardRequestParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRequestParsers {
    final Logger log = LoggerFactory.getLogger(SolrRequestParsers.class);
    public static final String MULTIPART = "multipart";
    public static final String RAW = "raw";
    public static final String SIMPLE = "simple";
    public static final String STANDARD = "standard";
    private HashMap<String, SolrRequestParser> parsers;
    private boolean enableRemoteStreams = false;
    private boolean handleSelect = true;
    private StandardRequestParser standard;

    public SolrRequestParsers(Config globalConfig) {
        long uploadLimitKB = 1048L;
        if (globalConfig == null) {
            uploadLimitKB = Long.MAX_VALUE;
            this.enableRemoteStreams = true;
            this.handleSelect = true;
        } else {
            uploadLimitKB = globalConfig.getInt("requestDispatcher/requestParsers/@multipartUploadLimitInKB", (int)uploadLimitKB);
            this.enableRemoteStreams = globalConfig.getBool("requestDispatcher/requestParsers/@enableRemoteStreaming", false);
            this.handleSelect = globalConfig.getBool("requestDispatcher/@handleSelect", this.handleSelect);
        }
        MultipartRequestParser multi = new MultipartRequestParser(uploadLimitKB);
        RawRequestParser raw = new RawRequestParser();
        this.standard = new StandardRequestParser(multi, raw);
        this.parsers = new HashMap();
        this.parsers.put(MULTIPART, multi);
        this.parsers.put(RAW, raw);
        this.parsers.put(SIMPLE, new SimpleRequestParser());
        this.parsers.put(STANDARD, this.standard);
        this.parsers.put("", this.standard);
    }

    public SolrQueryRequest parse(SolrCore core, String path, HttpServletRequest req) throws Exception {
        StandardRequestParser parser = this.standard;
        ArrayList<ContentStream> streams = new ArrayList<ContentStream>(1);
        SolrParams params = parser.parseParamsAndFillStreams(req, streams);
        SolrQueryRequest sreq = this.buildRequestFrom(core, params, streams);
        sreq.getContext().put("path", path);
        return sreq;
    }

    public SolrQueryRequest buildRequestFrom(SolrCore core, SolrParams params, Collection<ContentStream> streams) throws Exception {
        ContentStreamBase.URLStream stream;
        String contentType = params.get("stream.contentType");
        String[] strs = params.getParams("stream.url");
        if (strs != null) {
            if (!this.enableRemoteStreams) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Remote Streaming is disabled.");
            }
            for (String url : strs) {
                stream = new ContentStreamBase.URLStream(new URL(url));
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        if ((strs = params.getParams("stream.file")) != null) {
            if (!this.enableRemoteStreams) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Remote Streaming is disabled.");
            }
            for (String file : strs) {
                stream = new ContentStreamBase.FileStream(new File(file));
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        if ((strs = params.getParams("stream.body")) != null) {
            for (String body : strs) {
                stream = new ContentStreamBase.StringStream(body);
                if (contentType != null) {
                    stream.setContentType(contentType);
                }
                streams.add((ContentStream)stream);
            }
        }
        SolrQueryRequestBase q = new SolrQueryRequestBase(core, params){};
        if (streams != null && streams.size() > 0) {
            q.setContentStreams(streams);
        }
        return q;
    }

    public static MultiMapSolrParams parseQueryString(String queryString) {
        HashMap map = new HashMap();
        if (queryString != null && queryString.length() > 0) {
            try {
                for (String kv : queryString.split("&")) {
                    String name;
                    int idx = kv.indexOf(61);
                    if (idx > 0) {
                        name = URLDecoder.decode(kv.substring(0, idx), "UTF-8");
                        String value = URLDecoder.decode(kv.substring(idx + 1), "UTF-8");
                        MultiMapSolrParams.addParam((String)name, (String)value, map);
                        continue;
                    }
                    name = URLDecoder.decode(kv, "UTF-8");
                    MultiMapSolrParams.addParam((String)name, (String)"", map);
                }
            }
            catch (UnsupportedEncodingException uex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)uex);
            }
        }
        return new MultiMapSolrParams(map);
    }

    public boolean isHandleSelect() {
        return this.handleSelect;
    }

    public void setHandleSelect(boolean handleSelect) {
        this.handleSelect = handleSelect;
    }
}

