/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;

public class TermQParserPlugin
extends QParserPlugin {
    public static String NAME = "term";

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new QParser(qstr, localParams, params, req){

            @Override
            public Query parse() throws ParseException {
                String fname = this.localParams.get("f");
                FieldType ft = this.req.getSchema().getFieldTypeNoEx(fname);
                String val = this.localParams.get("v");
                BytesRef term = new BytesRef();
                if (ft != null) {
                    ft.readableToIndexed(val, term);
                } else {
                    term.copyChars((CharSequence)val);
                }
                return new TermQuery(new Term(fname, term));
            }
        };
    }
}

