/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.queries.function.FunctionQuery;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.DocTransformers;
import org.apache.solr.response.transform.RenameFieldTransformer;
import org.apache.solr.response.transform.ScoreAugmenter;
import org.apache.solr.response.transform.TransformerFactory;
import org.apache.solr.response.transform.ValueSourceAugmenter;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReturnFields {
    static final Logger log = LoggerFactory.getLogger(ReturnFields.class);
    public static final String SCORE = "score";
    private final List<String> globs = new ArrayList<String>(1);
    private final Set<String> fields = new LinkedHashSet<String>();
    private Set<String> okFieldNames = new HashSet<String>();
    private Set<String> reqFieldNames = null;
    private DocTransformer transformer;
    private boolean _wantsScore = false;
    private boolean _wantsAllFields = false;

    public ReturnFields() {
        this._wantsAllFields = true;
    }

    public ReturnFields(SolrQueryRequest req) {
        this(req.getParams().getParams("fl"), req);
    }

    public ReturnFields(String fl, SolrQueryRequest req) {
        if (fl == null) {
            this.parseFieldList(null, req);
        } else if (fl.trim().length() == 0) {
            this._wantsScore = true;
            this._wantsAllFields = true;
            this.transformer = new ScoreAugmenter(SCORE);
        } else {
            this.parseFieldList(new String[]{fl}, req);
        }
    }

    public ReturnFields(String[] fl, SolrQueryRequest req) {
        this.parseFieldList(fl, req);
    }

    private void parseFieldList(String[] fl, SolrQueryRequest req) {
        this._wantsScore = false;
        this._wantsAllFields = false;
        if (fl == null || fl.length == 0 || fl.length == 1 && fl[0].length() == 0) {
            this._wantsAllFields = true;
            return;
        }
        NamedList rename = new NamedList();
        DocTransformers augmenters = new DocTransformers();
        for (String fieldList : fl) {
            this.add(fieldList, (NamedList<String>)rename, augmenters, req);
        }
        for (int i = 0; i < rename.size(); ++i) {
            boolean copy;
            String from = rename.getName(i);
            String to = (String)rename.getVal(i);
            this.okFieldNames.add(to);
            boolean bl = copy = this.reqFieldNames != null && this.reqFieldNames.contains(from);
            if (!copy) {
                for (int j = i + 1; j < rename.size(); ++j) {
                    if (!from.equals(rename.getName(j))) continue;
                    rename.setName(j, to);
                    if (this.reqFieldNames == null) {
                        this.reqFieldNames = new HashSet<String>();
                    }
                    this.reqFieldNames.add(to);
                }
            }
            augmenters.addTransformer(new RenameFieldTransformer(from, to, copy));
        }
        if (!this._wantsAllFields) {
            if (!this.globs.isEmpty()) {
                this.fields.clear();
            }
            this.okFieldNames.addAll(this.fields);
        }
        if (augmenters.size() == 1) {
            this.transformer = augmenters.getTransformer(0);
        } else if (augmenters.size() > 1) {
            this.transformer = augmenters;
        }
    }

    String getFieldName(QueryParsing.StrParser sp) throws ParseException {
        char ch;
        sp.eatws();
        int id_start = sp.pos;
        if (sp.pos < sp.end && (ch = sp.val.charAt(sp.pos)) != '$' && Character.isJavaIdentifierStart(ch)) {
            ++sp.pos;
            while (sp.pos < sp.end && (Character.isJavaIdentifierPart(ch = sp.val.charAt(sp.pos)) || ch == '.' || ch == '-')) {
                ++sp.pos;
            }
            return sp.val.substring(id_start, sp.pos);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void add(String fl, NamedList<String> rename, DocTransformers augmenters, SolrQueryRequest req) {
        if (fl == null) {
            return;
        }
        try {
            QueryParsing.StrParser sp = new QueryParsing.StrParser(fl);
            while (true) {
                String funcStr;
                sp.opt(',');
                sp.eatws();
                if (sp.pos >= sp.end) {
                    return;
                }
                int start = sp.pos;
                String key = null;
                String field = this.getFieldName(sp);
                char ch = sp.ch();
                if (field != null) {
                    if (sp.opt(':')) {
                        key = field;
                        field = null;
                        sp.eatws();
                        start = sp.pos;
                    } else {
                        if (ch == ' ' || ch == ',' || ch == '\u0000') {
                            this.addField(field, key, augmenters, req);
                            continue;
                        }
                        sp.pos = start;
                        field = null;
                    }
                }
                if (key != null) {
                    field = sp.getId(null);
                    ch = sp.ch();
                    if (field != null && (ch == ' ' || ch == ',' || ch == '\u0000')) {
                        rename.add(field, (Object)key);
                        this.addField(field, key, augmenters, req);
                        continue;
                    }
                    sp.pos = start;
                    field = null;
                }
                if (field == null) {
                    field = sp.getGlobbedId(null);
                    ch = sp.ch();
                    if (field != null && (ch == ' ' || ch == ',' || ch == '\u0000')) {
                        if ("*".equals(field)) {
                            this._wantsAllFields = true;
                            continue;
                        }
                        this.globs.add(field);
                        continue;
                    }
                    sp.pos = start;
                }
                if ((funcStr = sp.val.substring(start)).startsWith("[")) {
                    TransformerFactory factory;
                    HashMap<String, String> augmenterArgs = new HashMap<String, String>();
                    int end = QueryParsing.parseLocalParams(funcStr, 0, augmenterArgs, req.getParams(), "[", ']');
                    sp.pos += end;
                    String string = (String)augmenterArgs.remove("type");
                    String disp = key;
                    if (disp == null) {
                        disp = '[' + string + ']';
                    }
                    if ((factory = req.getCore().getTransformerFactory(string)) != null) {
                        MapSolrParams augmenterParams = new MapSolrParams(augmenterArgs);
                        augmenters.addTransformer(factory.create(disp, (SolrParams)augmenterParams, req));
                    }
                    this.addField(field, disp, augmenters, req);
                    continue;
                }
                QParser parser = QParser.getParser(funcStr, FunctionQParserPlugin.NAME, req);
                Query q = null;
                Object var13_17 = null;
                try {
                    void var13_20;
                    block30: {
                        block31: {
                            if (!(parser instanceof FunctionQParser)) break block31;
                            FunctionQParser fparser = (FunctionQParser)parser;
                            fparser.setParseMultipleSources(false);
                            fparser.setParseToEnd(false);
                            q = fparser.getQuery();
                            if (fparser.localParams != null) {
                                if (fparser.valFollowedParams) {
                                    int leftOver = fparser.sp.end - fparser.sp.pos;
                                    sp.pos = sp.end - leftOver;
                                    break block30;
                                } else {
                                    sp.pos = start + fparser.localParamsEnd;
                                }
                                break block30;
                            } else {
                                int leftOver = fparser.sp.end - fparser.sp.pos;
                                sp.pos = sp.end - leftOver;
                            }
                            break block30;
                        }
                        q = parser.getQuery();
                        assert (parser.getLocalParams() != null);
                        sp.pos = start + parser.localParamsEnd;
                    }
                    if (q instanceof FunctionQuery) {
                        ValueSource valueSource = ((FunctionQuery)q).getValueSource();
                    } else {
                        QueryValueSource queryValueSource = new QueryValueSource(q, 0.0f);
                    }
                    if (key == null) {
                        SolrParams localParams = parser.getLocalParams();
                        if (localParams != null) {
                            key = localParams.get("key");
                        }
                        if (key == null) {
                            key = sp.val.substring(start, sp.pos);
                        }
                    }
                    if (key == null) {
                        key = funcStr;
                    }
                    this.okFieldNames.add(key);
                    this.okFieldNames.add(funcStr);
                    augmenters.addTransformer(new ValueSourceAugmenter(key, parser, (ValueSource)var13_20));
                }
                catch (ParseException e) {
                    sp.pos = start;
                    field = sp.getSimpleString();
                    if (req.getSchema().getFieldOrNull(field) == null) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing fieldname: " + e.getMessage(), (Throwable)e);
                    this.fields.add(field);
                    if (key == null) continue;
                    rename.add(field, (Object)key);
                }
            }
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error parsing fieldname", (Throwable)e);
        }
    }

    private void addField(String field, String key, DocTransformers augmenters, SolrQueryRequest req) {
        if (key == null) {
            if (this.reqFieldNames == null) {
                this.reqFieldNames = new HashSet<String>();
            }
            this.reqFieldNames.add(field);
        }
        this.fields.add(field);
        this.okFieldNames.add(field);
        this.okFieldNames.add(key);
        if (SCORE.equals(field)) {
            this._wantsScore = true;
            String disp = key == null ? field : key;
            augmenters.addTransformer(new ScoreAugmenter(disp));
        }
    }

    public Set<String> getLuceneFieldNames() {
        return this._wantsAllFields || this.fields.isEmpty() ? null : this.fields;
    }

    public boolean wantsAllFields() {
        return this._wantsAllFields;
    }

    public boolean wantsScore() {
        return this._wantsScore;
    }

    public boolean wantsField(String name) {
        if (this._wantsAllFields || this.okFieldNames.contains(name)) {
            return true;
        }
        for (String s : this.globs) {
            if (!FilenameUtils.wildcardMatch((String)name, (String)s)) continue;
            this.okFieldNames.add(name);
            return true;
        }
        return false;
    }

    public DocTransformer getTransformer() {
        return this.transformer;
    }
}

