/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.NamedParser;

abstract class Double2Parser
extends NamedParser {
    public Double2Parser(String name) {
        super(name);
    }

    public abstract double func(int var1, FunctionValues var2, FunctionValues var3);

    @Override
    public ValueSource parse(FunctionQParser fp) throws ParseException {
        return new Function(fp.parseValueSource(), fp.parseValueSource());
    }

    class Function
    extends ValueSource {
        private final ValueSource a;
        private final ValueSource b;

        public Function(ValueSource a, ValueSource b) {
            this.a = a;
            this.b = b;
        }

        public String description() {
            return Double2Parser.this.name() + "(" + this.a.description() + "," + this.b.description() + ")";
        }

        public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
            final FunctionValues aVals = this.a.getValues(context, readerContext);
            final FunctionValues bVals = this.b.getValues(context, readerContext);
            return new DoubleDocValues(this){

                public double doubleVal(int doc) {
                    return Double2Parser.this.func(doc, aVals, bVals);
                }

                public String toString(int doc) {
                    return Double2Parser.this.name() + '(' + aVals.toString(doc) + ',' + bVals.toString(doc) + ')';
                }
            };
        }

        public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        }

        public int hashCode() {
            int h = this.a.hashCode();
            h ^= h << 13 | h >>> 20;
            h += this.b.hashCode();
            h ^= h << 23 | h >>> 10;
            return h += Double2Parser.this.name().hashCode();
        }

        public boolean equals(Object o) {
            if (((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Function other = (Function)((Object)o);
            return this.a.equals((Object)other.a) && this.b.equals((Object)other.b);
        }
    }
}

