/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public class TextField
extends FieldType {
    protected boolean autoGeneratePhraseQueries;
    protected Analyzer multiTermAnalyzer = null;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.properties |= 2;
        if (schema.getVersion() > 1.1f) {
            this.properties &= 0xFFFFFFDF;
        }
        this.autoGeneratePhraseQueries = !(schema.getVersion() > 1.3f);
        String autoGeneratePhraseQueriesStr = args.remove("autoGeneratePhraseQueries");
        if (autoGeneratePhraseQueriesStr != null) {
            this.autoGeneratePhraseQueries = Boolean.parseBoolean(autoGeneratePhraseQueriesStr);
        }
        super.init(schema, args);
    }

    public Analyzer getMultiTermAnalyzer() {
        return this.multiTermAnalyzer;
    }

    public void setMultiTermAnalyzer(Analyzer analyzer) {
        this.multiTermAnalyzer = analyzer;
    }

    public boolean getAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return TextField.parseFieldQuery(parser, this.getQueryAnalyzer(), field.getName(), externalVal);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return term.utf8ToString();
    }

    @Override
    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public void setQueryAnalyzer(Analyzer analyzer) {
        this.queryAnalyzer = analyzer;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        Analyzer multiAnalyzer = this.getMultiTermAnalyzer();
        BytesRef lower = TextField.analyzeMultiTerm(field.getName(), part1, multiAnalyzer);
        BytesRef upper = TextField.analyzeMultiTerm(field.getName(), part2, multiAnalyzer);
        return new TermRangeQuery(field.getName(), lower, upper, minInclusive, maxInclusive);
    }

    public static BytesRef analyzeMultiTerm(String field, String part, Analyzer analyzerIn) {
        TokenStream source;
        if (part == null) {
            return null;
        }
        try {
            source = analyzerIn.tokenStream(field, (Reader)new StringReader(part));
            source.reset();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to initialize TokenStream to analyze multiTerm term: " + part, (Throwable)e);
        }
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
        BytesRef bytes = termAtt.getBytesRef();
        try {
            if (!source.incrementToken()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "analyzer returned no terms for multiTerm term: " + part);
            }
            termAtt.fillBytesRef();
            if (source.incrementToken()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "analyzer returned too many terms for multiTerm term: " + part);
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error analyzing range part: " + part, (Throwable)e);
        }
        try {
            source.end();
            source.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to end & close TokenStream after analyzing multiTerm term: " + part, e);
        }
        return BytesRef.deepCopyOf((BytesRef)bytes);
    }

    static Query parseFieldQuery(QParser parser, Analyzer analyzer, String field, String queryText) {
        TokenStream source;
        int phraseSlop = 0;
        try {
            source = analyzer.tokenStream(field, (Reader)new StringReader(queryText));
            source.reset();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize TokenStream to analyze query text", e);
        }
        CachingTokenFilter buffer = new CachingTokenFilter(source);
        CharTermAttribute termAtt = null;
        PositionIncrementAttribute posIncrAtt = null;
        int numTokens = 0;
        try {
            buffer.reset();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize TokenStream to analyze query text", e);
        }
        if (buffer.hasAttribute(CharTermAttribute.class)) {
            termAtt = (CharTermAttribute)buffer.getAttribute(CharTermAttribute.class);
        }
        if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
            posIncrAtt = (PositionIncrementAttribute)buffer.getAttribute(PositionIncrementAttribute.class);
        }
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        boolean hasMoreTokens = false;
        if (termAtt != null) {
            try {
                hasMoreTokens = buffer.incrementToken();
                while (hasMoreTokens) {
                    int positionIncrement;
                    ++numTokens;
                    int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                    } else {
                        severalTokensAtSamePosition = true;
                    }
                    hasMoreTokens = buffer.incrementToken();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            buffer.reset();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (numTokens == 0) {
            return null;
        }
        if (numTokens == 1) {
            String term = null;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                term = termAtt.toString();
            }
            catch (IOException e) {
                // empty catch block
            }
            return new TermQuery(new Term(field, term));
        }
        if (severalTokensAtSamePosition) {
            if (positionCount == 1) {
                BooleanQuery q = new BooleanQuery(true);
                for (int i = 0; i < numTokens; ++i) {
                    String term = null;
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        term = termAtt.toString();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    TermQuery currentQuery = new TermQuery(new Term(field, term));
                    q.add((Query)currentQuery, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            MultiPhraseQuery mpq = new MultiPhraseQuery();
            mpq.setSlop(phraseSlop);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (positionIncrement > 0 && multiTerms.size() > 0) {
                    mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                    multiTerms.clear();
                }
                position += positionIncrement;
                multiTerms.add(new Term(field, term));
            }
            mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
            return mpq;
        }
        PhraseQuery pq = new PhraseQuery();
        pq.setSlop(phraseSlop);
        int position = -1;
        for (int i = 0; i < numTokens; ++i) {
            String term = null;
            int positionIncrement = 1;
            try {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                term = termAtt.toString();
                if (posIncrAtt != null) {
                    positionIncrement = posIncrAtt.getPositionIncrement();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            pq.add(new Term(field, term), position += positionIncrement);
        }
        return pq;
    }
}

