/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.CloudState;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.RefCounted;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreAdminHandler
extends RequestHandlerBase {
    protected static Logger log = LoggerFactory.getLogger(CoreAdminHandler.class);
    protected final CoreContainer coreContainer;
    private ShardHandlerFactory shardHandlerFactory;
    private ShardHandler shardHandler;

    public CoreAdminHandler() {
        this.coreContainer = null;
    }

    public CoreAdminHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
        this.shardHandlerFactory = coreContainer.getShardHandlerFactory();
        this.shardHandler = this.shardHandlerFactory.getShardHandler();
    }

    @Override
    public final void init(NamedList args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        boolean doPersist = false;
        SolrParams params = req.getParams();
        CoreAdminParams.CoreAdminAction action = CoreAdminParams.CoreAdminAction.STATUS;
        String a = params.get("action");
        if (a != null && (action = CoreAdminParams.CoreAdminAction.get((String)a)) == null) {
            doPersist = this.handleCustomAction(req, rsp);
        }
        if (action != null) {
            switch (action) {
                case CREATE: {
                    doPersist = this.handleCreateAction(req, rsp);
                    break;
                }
                case RENAME: {
                    doPersist = this.handleRenameAction(req, rsp);
                    break;
                }
                case UNLOAD: {
                    doPersist = this.handleUnloadAction(req, rsp);
                    break;
                }
                case STATUS: {
                    doPersist = this.handleStatusAction(req, rsp);
                    break;
                }
                case PERSIST: {
                    doPersist = this.handlePersistAction(req, rsp);
                    break;
                }
                case RELOAD: {
                    doPersist = this.handleReloadAction(req, rsp);
                    break;
                }
                case SWAP: {
                    doPersist = this.handleSwapAction(req, rsp);
                    break;
                }
                case MERGEINDEXES: {
                    doPersist = this.handleMergeAction(req, rsp);
                    break;
                }
                case PREPRECOVERY: {
                    this.handleWaitForStateAction(req, rsp);
                    break;
                }
                case REQUESTRECOVERY: {
                    this.handleRequestRecoveryAction(req, rsp);
                    break;
                }
                case DISTRIBURL: {
                    this.handleDistribUrlAction(req, rsp);
                    break;
                }
                default: {
                    doPersist = this.handleCustomAction(req, rsp);
                }
                case LOAD: 
            }
        }
        if (doPersist) {
            cores.persist();
            rsp.add("saved", cores.getConfigFile().getAbsolutePath());
        }
        rsp.setHttpCaching(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleMergeAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SolrParams params = req.getParams();
        String cname = params.required().get("core");
        SolrCore core = this.coreContainer.getCore(cname);
        SolrQueryRequest wrappedReq = null;
        Object[] sourceCores = null;
        Object[] searchers = null;
        DirectoryReader[] readersToBeClosed = null;
        Directory[] dirsToBeReleased = null;
        if (core != null) {
            block27: {
                try {
                    int i;
                    String[] stringArray = params.getParams("indexDir");
                    if (stringArray == null || stringArray.length == 0) {
                        String[] sources = params.getParams("srcCore");
                        if (sources == null || sources.length == 0) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one indexDir or srcCore must be specified");
                        }
                        sourceCores = new SolrCore[sources.length];
                        for (i = 0; i < sources.length; ++i) {
                            String source = sources[i];
                            SolrCore srcCore = this.coreContainer.getCore(source);
                            if (srcCore == null) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core: " + source + " does not exist");
                            }
                            sourceCores[i] = srcCore;
                        }
                    } else {
                        readersToBeClosed = new DirectoryReader[stringArray.length];
                        dirsToBeReleased = new Directory[stringArray.length];
                        DirectoryFactory dirFactory = core.getDirectoryFactory();
                        for (i = 0; i < stringArray.length; ++i) {
                            Directory dir;
                            dirsToBeReleased[i] = dir = dirFactory.get(stringArray[i], core.getSolrConfig().indexConfig.lockType);
                            readersToBeClosed[i] = DirectoryReader.open((Directory)dir);
                        }
                    }
                    DirectoryReader[] readers = null;
                    if (readersToBeClosed != null) {
                        readers = readersToBeClosed;
                    } else {
                        readers = new DirectoryReader[sourceCores.length];
                        searchers = new RefCounted[sourceCores.length];
                        for (i = 0; i < sourceCores.length; ++i) {
                            Directory solrCore = sourceCores[i];
                            searchers[i] = solrCore.getSearcher();
                            readers[i] = ((SolrIndexSearcher)searchers[i].get()).getIndexReader();
                        }
                    }
                    UpdateRequestProcessorChain processorChain = core.getUpdateProcessingChain(params.get("update.chain"));
                    wrappedReq = new LocalSolrQueryRequest(core, req.getParams());
                    UpdateRequestProcessor processor = processorChain.createProcessor(wrappedReq, rsp);
                    processor.processMergeIndexes(new MergeIndexesCommand(readers, req));
                    if (searchers == null) break block27;
                }
                catch (Throwable throwable) {
                    if (searchers != null) {
                        for (Directory searcher : searchers) {
                            if (searcher == null) continue;
                            searcher.decref();
                        }
                    }
                    if (sourceCores != null) {
                        for (Directory solrCore : sourceCores) {
                            if (solrCore == null) continue;
                            solrCore.close();
                        }
                    }
                    if (readersToBeClosed != null) {
                        IOUtils.closeWhileHandlingException(readersToBeClosed);
                    }
                    if (dirsToBeReleased != null) {
                        for (Directory dir : dirsToBeReleased) {
                            DirectoryFactory dirFactory = core.getDirectoryFactory();
                            dirFactory.release(dir);
                        }
                    }
                    if (wrappedReq != null) {
                        wrappedReq.close();
                    }
                    core.close();
                    throw throwable;
                }
                for (Directory searcher : searchers) {
                    if (searcher == null) continue;
                    searcher.decref();
                }
            }
            if (sourceCores != null) {
                for (Directory solrCore : sourceCores) {
                    if (solrCore == null) continue;
                    solrCore.close();
                }
            }
            if (readersToBeClosed != null) {
                IOUtils.closeWhileHandlingException((Closeable[])readersToBeClosed);
            }
            if (dirsToBeReleased != null) {
                for (Directory dir : dirsToBeReleased) {
                    DirectoryFactory dirFactory = core.getDirectoryFactory();
                    dirFactory.release(dir);
                }
            }
            if (wrappedReq != null) {
                wrappedReq.close();
            }
            core.close();
        }
        return this.coreContainer.isPersistent();
    }

    protected boolean handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported operation: " + req.getParams().get("action"));
    }

    protected boolean handleCreateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        try {
            CloudDescriptor cd;
            SolrParams params = req.getParams();
            String name = params.get("name");
            if (this.coreContainer.getZkController() != null && this.coreContainer.getCore(name) != null) {
                log.info("Re-creating a core with existing name is not allowed in cloud mode");
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with name '" + name + "' already exists.");
            }
            String instanceDir = params.get("instanceDir");
            if (instanceDir == null) {
                instanceDir = name;
            }
            CoreDescriptor dcore = new CoreDescriptor(this.coreContainer, name, instanceDir);
            String opts = params.get("config");
            if (opts != null) {
                dcore.setConfigName(opts);
            }
            if ((opts = params.get("schema")) != null) {
                dcore.setSchemaName(opts);
            }
            if ((opts = params.get("dataDir")) != null) {
                dcore.setDataDir(opts);
            }
            if ((cd = dcore.getCloudDescriptor()) != null) {
                Integer numShards;
                cd.setParams(req.getParams());
                opts = params.get("collection");
                if (opts != null) {
                    cd.setCollectionName(opts);
                }
                if ((opts = params.get("shard")) != null) {
                    cd.setShardId(opts);
                }
                if ((opts = params.get("roles")) != null) {
                    cd.setRoles(opts);
                }
                if ((numShards = params.getInt("numShards")) != null) {
                    cd.setNumShards(numShards);
                }
            }
            Properties coreProperties = new Properties();
            Iterator parameterNamesIterator = params.getParameterNamesIterator();
            while (parameterNamesIterator.hasNext()) {
                String parameterName = (String)parameterNamesIterator.next();
                if (!parameterName.startsWith("property.")) continue;
                String parameterValue = params.get(parameterName);
                String propertyName = parameterName.substring("property.".length());
                coreProperties.put(propertyName, parameterValue);
            }
            dcore.setCoreProperties(coreProperties);
            SolrCore core = this.coreContainer.create(dcore);
            this.coreContainer.register(name, core, false);
            rsp.add("core", core.getName());
            return this.coreContainer.isPersistent();
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error executing default implementation of CREATE", (Throwable)ex);
        }
    }

    protected boolean handleRenameAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String name = params.get("other");
        String cname = params.get("core");
        boolean doPersist = false;
        if (cname.equals(name)) {
            return doPersist;
        }
        doPersist = this.coreContainer.isPersistent();
        this.coreContainer.rename(cname, name);
        return doPersist;
    }

    @Deprecated
    protected boolean handleAliasAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String name = params.get("other");
        String cname = params.get("core");
        boolean doPersist = false;
        if (cname.equals(name)) {
            return doPersist;
        }
        SolrCore core = this.coreContainer.getCore(cname);
        if (core != null) {
            doPersist = this.coreContainer.isPersistent();
            this.coreContainer.register(name, core, false);
        }
        return doPersist;
    }

    protected boolean handleUnloadAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        SolrCore core = this.coreContainer.remove(cname);
        if (core == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core exists '" + cname + "'");
        }
        if (this.coreContainer.getZkController() != null) {
            log.info("Unregistering core " + cname + " from cloudstate.");
            try {
                this.coreContainer.getZkController().unregister(cname, core.getCoreDescriptor().getCloudDescriptor());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not unregister core " + cname + " from cloudstate: " + e.getMessage(), (Throwable)e);
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not unregister core " + cname + " from cloudstate: " + e.getMessage(), (Throwable)e);
            }
        }
        if (params.getBool("deleteIndex", false)) {
            core.addCloseHook(new CloseHook(){

                @Override
                public void preClose(SolrCore core) {
                }

                @Override
                public void postClose(SolrCore core) {
                    File dataDir = new File(core.getIndexDir());
                    File[] files = dataDir.listFiles();
                    if (files != null) {
                        for (File file : files) {
                            if (file.delete()) continue;
                            log.error(file.getAbsolutePath() + " could not be deleted on core unload");
                        }
                        if (!dataDir.delete()) {
                            log.error(dataDir.getAbsolutePath() + " could not be deleted on core unload");
                        }
                    } else {
                        log.error(dataDir.getAbsolutePath() + " could not be deleted on core unload");
                    }
                }
            });
        }
        core.close();
        return this.coreContainer.isPersistent();
    }

    protected boolean handleStatusAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        boolean doPersist = false;
        SimpleOrderedMap status = new SimpleOrderedMap();
        try {
            if (cname == null) {
                rsp.add("defaultCoreName", this.coreContainer.getDefaultCoreName());
                for (String name : this.coreContainer.getCoreNames()) {
                    status.add(name, this.getCoreStatus(this.coreContainer, name));
                }
            } else {
                status.add(cname, this.getCoreStatus(this.coreContainer, cname));
            }
            rsp.add("status", status);
            doPersist = false;
            return doPersist;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'status' action ", (Throwable)ex);
        }
    }

    protected boolean handlePersistAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        boolean doPersist = false;
        String fileName = params.get("file");
        if (fileName != null) {
            File file = new File(this.coreContainer.getConfigFile().getParentFile(), fileName);
            this.coreContainer.persistFile(file);
            rsp.add("saved", file.getAbsolutePath());
            doPersist = false;
        } else {
            if (!this.coreContainer.isPersistent()) {
                throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "Persistence is not enabled");
            }
            doPersist = true;
        }
        return doPersist;
    }

    protected boolean handleReloadAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        try {
            this.coreContainer.reload(cname);
            return false;
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'reload' action", (Throwable)ex);
        }
    }

    protected boolean handleSwapAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        RequiredSolrParams required = params.required();
        String cname = params.get("core");
        boolean doPersist = params.getBool("persistent", this.coreContainer.isPersistent());
        String other = required.get("other");
        this.coreContainer.swap(cname, other);
        return doPersist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequestRecoveryAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        if (cname == null) {
            cname = "";
        }
        SolrCore core = null;
        try {
            core = this.coreContainer.getCore(cname);
            if (core != null) {
                core.getUpdateHandler().getSolrCoreState().doRecovery(this.coreContainer, cname);
            } else {
                SolrException.log((Logger)log, (String)("Cound not find core to call recovery:" + cname));
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWaitForStateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, InterruptedException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        if (cname == null) {
            cname = "";
        }
        String nodeName = params.get("nodeName");
        String coreNodeName = params.get("coreNodeName");
        String waitForState = params.get("state");
        Boolean checkLive = params.getBool("checkLive");
        int pauseFor = params.getInt("pauseFor", 0);
        String state = null;
        boolean live = false;
        int retry = 0;
        while (true) {
            SolrCore core = null;
            try {
                core = this.coreContainer.getCore(cname);
                if (core == null && retry == 30) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "core not found:" + cname);
                }
                if (core != null) {
                    ZkNodeProps nodeProps;
                    String collection;
                    CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
                    CloudState cloudState = this.coreContainer.getZkController().getCloudState();
                    Slice slice = cloudState.getSlice(collection = cloudDescriptor.getCollectionName(), cloudDescriptor.getShardId());
                    if (slice != null && (nodeProps = (ZkNodeProps)slice.getShards().get(coreNodeName)) != null) {
                        state = nodeProps.get("state");
                        live = cloudState.liveNodesContain(nodeName);
                        if (nodeProps != null && state.equals(waitForState) && (checkLive == null || checkLive.booleanValue() && live || !checkLive.booleanValue() && !live)) break;
                    }
                }
                if (retry++ == 30) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "I was asked to wait on state " + waitForState + " for " + nodeName + " but I still do not see the request state. I see state: " + state + " live:" + live);
                }
            }
            finally {
                if (core != null) {
                    core.close();
                }
            }
            Thread.sleep(1000L);
        }
        Thread.sleep(pauseFor);
    }

    protected void handleDistribUrlAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, InterruptedException, SolrServerException {
        ShardResponse srsp;
        SolrParams params = req.getParams();
        ModifiableSolrParams newParams = new ModifiableSolrParams(params);
        newParams.remove("action");
        RequiredSolrParams required = params.required();
        String subAction = required.get("subAction");
        String collection = required.get("collection");
        newParams.set("action", new String[]{subAction});
        SolrCore core = req.getCore();
        ZkController zkController = core.getCoreDescriptor().getCoreContainer().getZkController();
        CloudState cloudState = zkController.getCloudState();
        Map slices = (Map)cloudState.getCollectionStates().get(collection);
        for (Map.Entry entry : slices.entrySet()) {
            Slice slice = (Slice)entry.getValue();
            Map shards = slice.getShards();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                ZkNodeProps node = (ZkNodeProps)shardEntry.getValue();
                if (!cloudState.liveNodesContain(node.get("node_name"))) continue;
                newParams.set("core", new String[]{node.get("core")});
                String replica = node.get("base_url");
                ShardRequest sreq = new ShardRequest();
                newParams.set("qt", new String[]{"/admin/cores"});
                sreq.purpose = 1;
                if (replica.startsWith("http://")) {
                    replica = replica.substring(7);
                }
                sreq.shards = new String[]{replica};
                sreq.actualShards = sreq.shards;
                sreq.params = newParams;
                this.shardHandler.submit(sreq, replica, sreq.params);
            }
        }
        do {
            Throwable e;
            if ((srsp = this.shardHandler.takeCompletedOrError()) == null || (e = srsp.getException()) == null) continue;
            log.error("Error talking to shard: " + srsp.getShard(), e);
        } while (srsp != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedList<Object> getCoreStatus(CoreContainer cores, String cname) throws IOException {
        SimpleOrderedMap info = new SimpleOrderedMap();
        SolrCore core = cores.getCore(cname);
        if (core != null) {
            try {
                info.add("name", (Object)core.getName());
                info.add("isDefaultCore", (Object)core.getName().equals(cores.getDefaultCoreName()));
                info.add("instanceDir", (Object)CoreAdminHandler.normalizePath(core.getResourceLoader().getInstanceDir()));
                info.add("dataDir", (Object)CoreAdminHandler.normalizePath(core.getDataDir()));
                info.add("config", (Object)core.getConfigResource());
                info.add("schema", (Object)core.getSchemaResource());
                info.add("startTime", (Object)new Date(core.getStartTime()));
                info.add("uptime", (Object)(System.currentTimeMillis() - core.getStartTime()));
                RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                try {
                    SimpleOrderedMap<Object> indexInfo = LukeRequestHandler.getIndexInfo(searcher.get().getIndexReader());
                    long size = this.getIndexSize(core);
                    indexInfo.add("sizeInBytes", (Object)size);
                    indexInfo.add("size", (Object)NumberUtils.readableSize(size));
                    info.add("index", indexInfo);
                }
                finally {
                    searcher.decref();
                }
            }
            finally {
                core.close();
            }
        }
        return info;
    }

    private long getIndexSize(SolrCore core) {
        return FileUtils.sizeOfDirectory((File)new File(core.getIndexDir()));
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_4x/solr/core/src/java/org/apache/solr/handler/admin/CoreAdminHandler.java $";
    }
}

