/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.net.URL;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.SolrPluginUtils;
import org.slf4j.Logger;

public abstract class RequestHandlerBase
implements SolrRequestHandler,
SolrInfoMBean {
    volatile long numRequests;
    volatile long numErrors;
    volatile long numTimeouts;
    protected NamedList initArgs = null;
    protected SolrParams defaults;
    protected SolrParams appends;
    protected SolrParams invariants;
    volatile long totalTime = 0L;
    long handlerStart = System.currentTimeMillis();
    protected boolean httpCaching = true;

    @Override
    public void init(NamedList args) {
        this.initArgs = args;
        if (args != null) {
            Object o = args.get("defaults");
            if (o != null && o instanceof NamedList) {
                this.defaults = SolrParams.toSolrParams((NamedList)((NamedList)o));
            }
            if ((o = args.get("appends")) != null && o instanceof NamedList) {
                this.appends = SolrParams.toSolrParams((NamedList)((NamedList)o));
            }
            if ((o = args.get("invariants")) != null && o instanceof NamedList) {
                this.invariants = SolrParams.toSolrParams((NamedList)((NamedList)o));
            }
        }
        if (this.initArgs != null) {
            Object caching = this.initArgs.get("httpCaching");
            this.httpCaching = caching != null ? Boolean.parseBoolean(caching.toString()) : true;
        }
    }

    public NamedList getInitArgs() {
        return this.initArgs;
    }

    public abstract void handleRequestBody(SolrQueryRequest var1, SolrQueryResponse var2) throws Exception;

    @Override
    public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
        ++this.numRequests;
        try {
            SolrPluginUtils.setDefaults(req, this.defaults, this.appends, this.invariants);
            rsp.setHttpCaching(this.httpCaching);
            this.handleRequestBody(req, rsp);
            NamedList<Object> header = rsp.getResponseHeader();
            if (header != null) {
                boolean timedOut;
                Object partialResults = header.get("partialResults");
                boolean bl = timedOut = partialResults == null ? false : (Boolean)partialResults;
                if (timedOut) {
                    ++this.numTimeouts;
                    rsp.setHttpCaching(false);
                }
            }
        }
        catch (Exception e2) {
            SolrException e2;
            if (e2 instanceof SolrException) {
                SolrException se = (SolrException)((Object)e2);
                if (se.code() != SolrException.ErrorCode.CONFLICT.code) {
                    SolrException.log((Logger)SolrCore.log, (Throwable)e2);
                }
            } else {
                SolrException.log((Logger)SolrCore.log, (Throwable)e2);
                if (e2 instanceof ParseException) {
                    e2 = new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e2);
                }
            }
            rsp.setException((Exception)((Object)e2));
            ++this.numErrors;
        }
        this.totalTime += rsp.getEndTime() - req.getStartTime();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public abstract String getDescription();

    @Override
    public abstract String getSource();

    @Override
    public String getVersion() {
        return this.getClass().getPackage().getSpecificationVersion();
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.QUERYHANDLER;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    public NamedList<Object> getStatistics() {
        SimpleOrderedMap lst = new SimpleOrderedMap();
        lst.add("handlerStart", (Object)this.handlerStart);
        lst.add("requests", (Object)this.numRequests);
        lst.add("errors", (Object)this.numErrors);
        lst.add("timeouts", (Object)this.numTimeouts);
        lst.add("totalTime", (Object)this.totalTime);
        lst.add("avgTimePerRequest", (Object)Float.valueOf((float)this.totalTime / (float)this.numRequests));
        lst.add("avgRequestsPerSecond", (Object)Float.valueOf((float)this.numRequests * 1000.0f / (float)(System.currentTimeMillis() - this.handlerStart)));
        return lst;
    }
}

