/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene40.Lucene40Codec;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class DefaultCodecFactory
extends CodecFactory {
    @Override
    public Codec create(final IndexSchema schema) {
        return new Lucene40Codec(){

            public PostingsFormat getPostingsFormatForField(String field) {
                SchemaField fieldOrNull = schema.getFieldOrNull(field);
                if (fieldOrNull == null) {
                    throw new IllegalArgumentException("no such field " + field);
                }
                String postingsFormatName = fieldOrNull.getType().getPostingsFormat();
                if (postingsFormatName != null) {
                    return PostingsFormat.forName((String)postingsFormatName);
                }
                return super.getPostingsFormatForField(field);
            }
        };
    }
}

