/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingDirectoryFactory
extends DirectoryFactory {
    private static Logger log = LoggerFactory.getLogger(CachingDirectoryFactory.class);
    protected Map<String, CacheValue> byPathCache = new HashMap<String, CacheValue>();
    protected Map<Directory, CacheValue> byDirectoryCache = new HashMap<Directory, CacheValue>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            for (CacheValue val : this.byDirectoryCache.values()) {
                val.directory.close();
            }
            this.byDirectoryCache.clear();
            this.byPathCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Directory directory) throws IOException {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            CacheValue cacheValue = this.byDirectoryCache.get(directory);
            if (cacheValue == null) {
                throw new IllegalArgumentException("Unknown directory: " + directory + " " + this.byDirectoryCache);
            }
            --cacheValue.refCnt;
            if (cacheValue.refCnt == 0 && cacheValue.doneWithDir) {
                directory.close();
                this.byDirectoryCache.remove(directory);
                this.byPathCache.remove(cacheValue.path);
            }
        }
    }

    @Override
    protected abstract Directory create(String var1) throws IOException;

    @Override
    public boolean exists(String path) {
        File dirFile = new File(path);
        return dirFile.canRead() && dirFile.list().length > 0;
    }

    @Override
    public final Directory get(String path, String rawLockType) throws IOException {
        return this.get(path, rawLockType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Directory get(String path, String rawLockType, boolean forceNew) throws IOException {
        String fullPath = new File(path).getAbsolutePath();
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            CacheValue cacheValue = this.byPathCache.get(fullPath);
            Directory directory = null;
            if (cacheValue != null) {
                directory = cacheValue.directory;
                if (forceNew) {
                    cacheValue.doneWithDir = true;
                    if (cacheValue.refCnt == 0) {
                        this.close(cacheValue.directory);
                    }
                }
            }
            if (directory == null || forceNew) {
                directory = this.create(fullPath);
                CacheValue newCacheValue = new CacheValue();
                newCacheValue.directory = directory;
                newCacheValue.path = fullPath;
                CachingDirectoryFactory.injectLockFactory(directory, path, rawLockType);
                this.byDirectoryCache.put(directory, newCacheValue);
                this.byPathCache.put(fullPath, newCacheValue);
            } else {
                ++cacheValue.refCnt;
            }
            return directory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incRef(Directory directory) {
        CachingDirectoryFactory cachingDirectoryFactory = this;
        synchronized (cachingDirectoryFactory) {
            CacheValue cacheValue = this.byDirectoryCache.get(directory);
            if (cacheValue == null) {
                throw new IllegalArgumentException("Unknown directory: " + directory);
            }
            ++cacheValue.refCnt;
        }
    }

    @Override
    public void init(NamedList args) {
    }

    @Override
    public void release(Directory directory) throws IOException {
        if (directory == null) {
            throw new NullPointerException();
        }
        this.close(directory);
    }

    private static Directory injectLockFactory(Directory dir, String lockPath, String rawLockType) throws IOException {
        String lockType;
        if (null == rawLockType) {
            log.warn("No lockType configured for " + dir + " assuming 'simple'");
            rawLockType = "simple";
        }
        if ("simple".equals(lockType = rawLockType.toLowerCase(Locale.ENGLISH).trim())) {
            dir.setLockFactory((LockFactory)new SimpleFSLockFactory(lockPath));
        } else if ("native".equals(lockType)) {
            dir.setLockFactory((LockFactory)new NativeFSLockFactory(lockPath));
        } else if ("single".equals(lockType)) {
            if (!(dir.getLockFactory() instanceof SingleInstanceLockFactory)) {
                dir.setLockFactory((LockFactory)new SingleInstanceLockFactory());
            }
        } else if ("none".equals(lockType)) {
            log.error("CONFIGURATION WARNING: locks are disabled on " + dir);
            dir.setLockFactory((LockFactory)NoLockFactory.getNoLockFactory());
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized lockType: " + rawLockType);
        }
        return dir;
    }

    class CacheValue {
        Directory directory;
        int refCnt = 1;
        public String path;
        public boolean doneWithDir = false;

        CacheValue() {
        }
    }
}

