/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

final class OverseerElectionContext
extends ElectionContext {
    private final SolrZkClient zkClient;
    private final ZkStateReader stateReader;

    public OverseerElectionContext(String zkNodeName, ZkStateReader stateReader) {
        super(zkNodeName, "/overseer_elect", "/overseer_elect/leader", null, stateReader.getZkClient());
        this.stateReader = stateReader;
        this.zkClient = stateReader.getZkClient();
    }

    @Override
    void runLeaderProcess(boolean weAreReplacement) throws KeeperException, InterruptedException {
        String id = this.leaderSeqPath.substring(this.leaderSeqPath.lastIndexOf("/") + 1);
        ZkNodeProps myProps = new ZkNodeProps(new String[]{"id", id});
        try {
            this.zkClient.makePath(this.leaderPath, ZkStateReader.toJSON((Object)myProps), CreateMode.EPHEMERAL, true);
        }
        catch (KeeperException.NodeExistsException e) {
            this.zkClient.delete(this.leaderPath, -1, true);
            this.zkClient.makePath(this.leaderPath, ZkStateReader.toJSON((Object)myProps), CreateMode.EPHEMERAL, true);
        }
        new Overseer(this.stateReader, id);
    }
}

