/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedQueue {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedQueue.class);
    private final String dir;
    private ZooKeeper zookeeper;
    private List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private final String prefix = "qn-";

    public DistributedQueue(ZooKeeper zookeeper, String dir, List<ACL> acl) {
        this.dir = dir;
        if (acl != null) {
            this.acl = acl;
        }
        this.zookeeper = zookeeper;
    }

    private TreeMap<Long, String> orderedChildren(Watcher watcher) throws KeeperException, InterruptedException {
        TreeMap<Long, String> orderedChildren = new TreeMap<Long, String>();
        List childNames = null;
        childNames = this.zookeeper.getChildren(this.dir, watcher);
        for (String childName : childNames) {
            try {
                if (!childName.regionMatches(0, "qn-", 0, "qn-".length())) {
                    LOG.warn("Found child node with improper name: " + childName);
                    continue;
                }
                String suffix = childName.substring("qn-".length());
                Long childId = new Long(suffix);
                orderedChildren.put(childId, childName);
            }
            catch (NumberFormatException e) {
                LOG.warn("Found child node with improper format : " + childName + " " + e, (Throwable)e);
            }
        }
        return orderedChildren;
    }

    public byte[] element() throws NoSuchElementException, KeeperException, InterruptedException {
        block4: while (true) {
            TreeMap<Long, String> orderedChildren;
            try {
                orderedChildren = this.orderedChildren(null);
            }
            catch (KeeperException.NoNodeException e) {
                throw new NoSuchElementException();
            }
            if (orderedChildren.size() == 0) {
                throw new NoSuchElementException();
            }
            Iterator<String> i$ = orderedChildren.values().iterator();
            while (true) {
                if (!i$.hasNext()) continue block4;
                String headNode = i$.next();
                if (headNode == null) continue;
                try {
                    return this.zookeeper.getData(this.dir + "/" + headNode, false, null);
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    public byte[] remove() throws NoSuchElementException, KeeperException, InterruptedException {
        block4: while (true) {
            TreeMap<Long, String> orderedChildren;
            try {
                orderedChildren = this.orderedChildren(null);
            }
            catch (KeeperException.NoNodeException e) {
                throw new NoSuchElementException();
            }
            if (orderedChildren.size() == 0) {
                throw new NoSuchElementException();
            }
            Iterator<String> i$ = orderedChildren.values().iterator();
            while (true) {
                if (!i$.hasNext()) continue block4;
                String headNode = i$.next();
                String path = this.dir + "/" + headNode;
                try {
                    byte[] data = this.zookeeper.getData(path, false, null);
                    this.zookeeper.delete(path, -1);
                    return data;
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public byte[] take() throws KeeperException, InterruptedException {
        block4: while (true) {
            childWatcher = new LatchChildWatcher();
            try {
                orderedChildren = this.orderedChildren(childWatcher);
            }
            catch (KeeperException.NoNodeException e) {
                this.zookeeper.create(this.dir, new byte[0], this.acl, CreateMode.PERSISTENT);
                continue;
            }
            if (orderedChildren.size() == 0) {
                childWatcher.await();
                continue;
            }
            i$ = orderedChildren.values().iterator();
            while (true) {
                if (i$.hasNext()) ** break;
                continue block4;
                headNode = i$.next();
                path = this.dir + "/" + headNode;
                try {
                    data = this.zookeeper.getData(path, false, null);
                    this.zookeeper.delete(path, -1);
                    return data;
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    public boolean offer(byte[] data) throws KeeperException, InterruptedException {
        while (true) {
            try {
                this.zookeeper.create(this.dir + "/" + "qn-", data, this.acl, CreateMode.PERSISTENT_SEQUENTIAL);
                return true;
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zookeeper.create(this.dir, new byte[0], this.acl, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                }
                continue;
            }
            break;
        }
    }

    public byte[] peek() throws KeeperException, InterruptedException {
        try {
            return this.element();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public byte[] poll() throws KeeperException, InterruptedException {
        try {
            return this.remove();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private class LatchChildWatcher
    implements Watcher {
        CountDownLatch latch = new CountDownLatch(1);

        public void process(WatchedEvent event) {
            LOG.debug("Watcher fired on path: " + event.getPath() + " state: " + event.getState() + " type " + event.getType());
            this.latch.countDown();
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

