/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrRequestParsers;

public class EmbeddedSolrServer
extends SolrServer {
    protected final CoreContainer coreContainer;
    protected final String coreName;
    private final SolrRequestParsers _parser;

    @Deprecated
    public EmbeddedSolrServer(SolrCore core) {
        if (core == null) {
            throw new NullPointerException("SolrCore instance required");
        }
        CoreDescriptor dcore = core.getCoreDescriptor();
        if (dcore == null) {
            throw new NullPointerException("CoreDescriptor required");
        }
        CoreContainer cores = dcore.getCoreContainer();
        if (cores == null) {
            throw new NullPointerException("CoreContainer required");
        }
        this.coreName = dcore.getName();
        this.coreContainer = cores;
        this._parser = new SolrRequestParsers(null);
    }

    public EmbeddedSolrServer(CoreContainer coreContainer, String coreName) {
        if (coreContainer == null) {
            throw new NullPointerException("CoreContainer instance required");
        }
        this.coreContainer = coreContainer;
        this.coreName = coreName == null ? "" : coreName;
        this._parser = new SolrRequestParsers(null);
    }

    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        SolrRequestHandler handler;
        SolrCore core;
        String path = request.getPath();
        if (path == null || !path.startsWith("/")) {
            path = "/select";
        }
        if ((core = this.coreContainer.getCore(this.coreName)) == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such core: " + this.coreName);
        }
        SolrParams params = request.getParams();
        if (params == null) {
            params = new ModifiableSolrParams();
        }
        if ((handler = core.getRequestHandler(path)) == null) {
            String qt;
            if (("/select".equals(path) || "/select/".equalsIgnoreCase(path)) && (handler = core.getRequestHandler(qt = params.get("qt"))) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
            }
            if (handler == null && this.coreContainer != null && path.equals(this.coreContainer.getAdminPath())) {
                handler = this.coreContainer.getMultiCoreHandler();
            }
        }
        if (handler == null) {
            core.close();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + path);
        }
        SolrQueryRequest req = null;
        try {
            NamedList<Object> normalized;
            req = this._parser.buildRequestFrom(core, params, request.getContentStreams());
            req.getContext().put("path", path);
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
            core.execute(handler, req, rsp);
            if (rsp.getException() != null) {
                if (rsp.getException() instanceof SolrException) {
                    throw rsp.getException();
                }
                throw new SolrServerException((Throwable)rsp.getException());
            }
            if (request.getStreamingResponseCallback() != null) {
                try {
                    final StreamingResponseCallback callback = request.getStreamingResponseCallback();
                    BinaryResponseWriter.Resolver resolver = new BinaryResponseWriter.Resolver(req, rsp.getReturnFields()){

                        @Override
                        public void writeResults(ResultContext ctx, JavaBinCodec codec) throws IOException {
                            SolrDocumentList docs = new SolrDocumentList();
                            docs.setNumFound((long)ctx.docs.matches());
                            docs.setStart((long)ctx.docs.offset());
                            docs.setMaxScore(Float.valueOf(ctx.docs.maxScore()));
                            codec.writeSolrDocumentList(docs);
                            this.writeResultsBody(ctx, codec);
                        }
                    };
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    new JavaBinCodec(resolver){

                        public void writeSolrDocument(SolrDocument doc) throws IOException {
                            callback.streamSolrDocument(doc);
                        }

                        public void writeSolrDocumentList(SolrDocumentList docs) throws IOException {
                            if (docs.size() > 0) {
                                SolrDocumentList tmp = new SolrDocumentList();
                                tmp.setMaxScore(docs.getMaxScore());
                                tmp.setNumFound(docs.getNumFound());
                                tmp.setStart(docs.getStart());
                                docs = tmp;
                            }
                            callback.streamDocListInfo(docs.getNumFound(), docs.getStart(), docs.getMaxScore());
                            super.writeSolrDocumentList(docs);
                        }
                    }.marshal((Object)rsp.getValues(), (OutputStream)out);
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    NamedList namedList = (NamedList)new JavaBinCodec((JavaBinCodec.ObjectResolver)resolver).unmarshal((InputStream)in);
                    return namedList;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            NamedList<Object> namedList = normalized = this.getParsedResponse(req, rsp);
            return namedList;
        }
        catch (IOException iox) {
            throw iox;
        }
        catch (SolrException sx) {
            throw sx;
        }
        catch (Exception ex) {
            throw new SolrServerException((Throwable)ex);
        }
        finally {
            if (req != null) {
                req.close();
            }
            core.close();
            SolrRequestInfo.clearRequestInfo();
        }
    }

    @Deprecated
    public NamedList<Object> getParsedResponse(SolrQueryRequest req, SolrQueryResponse rsp) {
        return BinaryResponseWriter.getParsedResponse(req, rsp);
    }

    public void shutdown() {
        this.coreContainer.shutdown();
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }
}

