/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class LengthFilterFactory
extends TokenFilterFactory {
    int min;
    int max;
    boolean enablePositionIncrements;
    public static final String MIN_KEY = "min";
    public static final String MAX_KEY = "max";

    public void init(Map<String, String> args) {
        super.init(args);
        this.min = Integer.parseInt(args.get(MIN_KEY));
        this.max = Integer.parseInt(args.get(MAX_KEY));
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
    }

    public LengthFilter create(TokenStream input) {
        return new LengthFilter(this.enablePositionIncrements, input, this.min, this.max);
    }
}

