/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.KeywordMarkerFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class KeywordMarkerFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    private CharArraySet protectedWords;
    private boolean ignoreCase;

    public void inform(ResourceLoader loader) {
        String wordFiles = (String)this.args.get(PROTECTED_TOKENS);
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (wordFiles != null) {
            try {
                this.protectedWords = this.getWordSet(loader, wordFiles, this.ignoreCase);
            }
            catch (IOException e) {
                throw new InitializationException("IOException thrown while loading protected words", (Throwable)e);
            }
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public TokenStream create(TokenStream input) {
        return this.protectedWords == null ? input : new KeywordMarkerFilter(input, this.protectedWords);
    }
}

