/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.HyphenationCompoundWordTokenFilter;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationTree;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.xml.sax.InputSource;

public class HyphenationCompoundWordTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet dictionary;
    private HyphenationTree hyphenator;
    private String dictFile;
    private String hypFile;
    private String encoding;
    private int minWordSize;
    private int minSubwordSize;
    private int maxSubwordSize;
    private boolean onlyLongestMatch;

    public void init(Map<String, String> args) {
        super.init(args);
        this.assureMatchVersion();
        this.dictFile = args.get("dictionary");
        if (args.containsKey("encoding")) {
            this.encoding = args.get("encoding");
        }
        this.hypFile = args.get("hyphenator");
        if (null == this.hypFile) {
            throw new InitializationException("Missing required parameter: hyphenator");
        }
        this.minWordSize = this.getInt("minWordSize", 5);
        this.minSubwordSize = this.getInt("minSubwordSize", 2);
        this.maxSubwordSize = this.getInt("maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean("onlyLongestMatch", false);
    }

    public void inform(ResourceLoader loader) {
        InputStream stream = null;
        try {
            if (this.dictFile != null) {
                this.dictionary = this.getWordSet(loader, this.dictFile, false);
            }
            stream = loader.openResource(this.hypFile);
            InputSource is = new InputSource(stream);
            is.setEncoding(this.encoding);
            is.setSystemId(this.hypFile);
            this.hyphenator = HyphenationCompoundWordTokenFilter.getHyphenationTree((InputSource)is);
        }
        catch (Exception e) {
            try {
                throw new InitializationException("Exception thrown while loading dictionary and hyphenation file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    public HyphenationCompoundWordTokenFilter create(TokenStream input) {
        return new HyphenationCompoundWordTokenFilter(this.luceneMatchVersion, input, this.hyphenator, this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

