/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharStream;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.analysis.util.CharFilterFactory;

public class HTMLStripCharFilterFactory
extends CharFilterFactory {
    Set<String> escapedTags = null;
    Pattern TAG_NAME_PATTERN = Pattern.compile("[^\\s,]+");

    public HTMLStripCharFilter create(CharStream input) {
        HTMLStripCharFilter charFilter = null == this.escapedTags ? new HTMLStripCharFilter(input) : new HTMLStripCharFilter(input, this.escapedTags);
        return charFilter;
    }

    public void init(Map<String, String> args) {
        super.init(args);
        String escapedTagsArg = args.get("escapedTags");
        if (null != escapedTagsArg) {
            Matcher matcher = this.TAG_NAME_PATTERN.matcher(escapedTagsArg);
            while (matcher.find()) {
                if (null == this.escapedTags) {
                    this.escapedTags = new HashSet<String>();
                }
                this.escapedTags.add(matcher.group(0));
            }
        }
    }
}

