/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ElisionFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet articles;

    public void inform(ResourceLoader loader) {
        String articlesFile = (String)this.args.get("articles");
        boolean ignoreCase = this.getBoolean("ignoreCase", false);
        if (articlesFile != null) {
            try {
                this.articles = this.getWordSet(loader, articlesFile, ignoreCase);
            }
            catch (IOException e) {
                throw new InitializationException("IOException thrown while loading articles", (Throwable)e);
            }
        }
    }

    public ElisionFilter create(TokenStream input) {
        this.assureMatchVersion();
        return this.articles == null ? new ElisionFilter(this.luceneMatchVersion, input) : new ElisionFilter(this.luceneMatchVersion, input, this.articles);
    }
}

