/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class EdgeNGramFilterFactory
extends TokenFilterFactory {
    private int maxGramSize = 0;
    private int minGramSize = 0;
    private String side;

    public void init(Map<String, String> args) {
        super.init(args);
        String maxArg = args.get("maxGramSize");
        this.maxGramSize = maxArg != null ? Integer.parseInt(maxArg) : 1;
        String minArg = args.get("minGramSize");
        this.minGramSize = minArg != null ? Integer.parseInt(minArg) : 1;
        this.side = args.get("side");
        if (this.side == null) {
            this.side = EdgeNGramTokenFilter.Side.FRONT.getLabel();
        }
    }

    public EdgeNGramTokenFilter create(TokenStream input) {
        return new EdgeNGramTokenFilter(input, this.side, this.minGramSize, this.maxGramSize);
    }
}

