/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.FloatEncoder;
import org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.apache.lucene.analysis.payloads.IntegerEncoder;
import org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class DelimitedPayloadTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String ENCODER_ATTR = "encoder";
    public static final String DELIMITER_ATTR = "delimiter";
    private PayloadEncoder encoder;
    private char delimiter = (char)124;

    public DelimitedPayloadTokenFilter create(TokenStream input) {
        return new DelimitedPayloadTokenFilter(input, this.delimiter, this.encoder);
    }

    public void init(Map<String, String> args) {
        super.init(args);
    }

    public void inform(ResourceLoader loader) {
        String encoderClass = (String)this.args.get(ENCODER_ATTR);
        this.encoder = encoderClass.equals("float") ? new FloatEncoder() : (encoderClass.equals("integer") ? new IntegerEncoder() : (encoderClass.equals("identity") ? new IdentityEncoder() : (PayloadEncoder)loader.newInstance(encoderClass, PayloadEncoder.class, new String[0])));
        String delim = (String)this.args.get(DELIMITER_ATTR);
        if (delim != null) {
            if (delim.length() == 1) {
                this.delimiter = delim.charAt(0);
            } else {
                throw new InitializationException("Delimiter must be one character only");
            }
        }
    }
}

