/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.commongrams.CommonGramsFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.InitializationException;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class CommonGramsFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet commonWords;
    private boolean ignoreCase;

    public void inform(ResourceLoader loader) {
        String commonWordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (commonWordFiles != null) {
            try {
                if ("snowball".equalsIgnoreCase((String)this.args.get("format"))) {
                    this.commonWords = this.getSnowballWordSet(loader, commonWordFiles, this.ignoreCase);
                }
                this.commonWords = this.getWordSet(loader, commonWordFiles, this.ignoreCase);
            }
            catch (IOException e) {
                throw new InitializationException("IOException thrown while loading common word file", (Throwable)e);
            }
        } else {
            this.commonWords = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getCommonWords() {
        return this.commonWords;
    }

    public CommonGramsFilter create(TokenStream input) {
        CommonGramsFilter commonGrams = new CommonGramsFilter(this.luceneMatchVersion, input, this.commonWords);
        return commonGrams;
    }
}

