/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.util.regex.Pattern;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.highlight.HighlightingPluginBase;
import org.apache.solr.highlight.LuceneRegexFragmenter;
import org.apache.solr.highlight.SolrFragmenter;

public class RegexFragmenter
extends HighlightingPluginBase
implements SolrFragmenter {
    protected String defaultPatternRaw;
    protected Pattern defaultPattern;

    public void init(NamedList args) {
        super.init(args);
        this.defaultPatternRaw = "[-\\w ,\\n\"']{20,200}";
        if (this.defaults != null) {
            this.defaultPatternRaw = this.defaults.get("hl.regex.pattern", "[-\\w ,\\n\"']{20,200}");
        }
        this.defaultPattern = Pattern.compile(this.defaultPatternRaw);
    }

    public Fragmenter getFragmenter(String fieldName, SolrParams params) {
        Pattern p;
        ++this.numRequests;
        params = SolrParams.wrapDefaults((SolrParams)params, (SolrParams)this.defaults);
        int fragsize = params.getFieldInt(fieldName, "hl.fragsize", 70);
        int increment = params.getFieldInt(fieldName, "hl.increment", 50);
        float slop = params.getFieldFloat(fieldName, "hl.regex.slop", 0.6f);
        int maxchars = params.getFieldInt(fieldName, "hl.regex.maxAnalyzedChars", 10000);
        String rawpat = params.getFieldParam(fieldName, "hl.regex.pattern", "[-\\w ,\\n\"']{20,200}");
        Pattern pattern = p = rawpat == this.defaultPatternRaw ? this.defaultPattern : Pattern.compile(rawpat);
        if (fragsize <= 0) {
            return new NullFragmenter();
        }
        return new LuceneRegexFragmenter(fragsize, increment, slop, maxchars, p);
    }

    public String getDescription() {
        return "RegexFragmenter (" + this.defaultPatternRaw + ")";
    }

    public String getVersion() {
        return "$Revision: 1213484 $";
    }

    public String getSourceId() {
        return "$Id: RegexFragmenter.java 1213484 2011-12-12 22:52:57Z hossman $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_6/solr/core/src/java/org/apache/solr/highlight/RegexFragmenter.java $";
    }
}

