/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.TermSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopGroupsFieldCommand
implements Command<TopGroups<String>> {
    private final SchemaField field;
    private final Sort groupSort;
    private final Sort sortWithinGroup;
    private final Collection<SearchGroup<String>> firstPhaseGroups;
    private final int maxDocPerGroup;
    private final boolean needScores;
    private final boolean needMaxScore;
    private final boolean needGroupCount;
    private TermSecondPassGroupingCollector secondPassCollector;
    private TermAllGroupsCollector allGroupsCollector;

    private TopGroupsFieldCommand(SchemaField field, Sort groupSort, Sort sortWithinGroup, Collection<SearchGroup<String>> firstPhaseGroups, int maxDocPerGroup, boolean needScores, boolean needMaxScore, boolean needGroupCount) {
        this.field = field;
        this.groupSort = groupSort;
        this.sortWithinGroup = sortWithinGroup;
        this.firstPhaseGroups = firstPhaseGroups;
        this.maxDocPerGroup = maxDocPerGroup;
        this.needScores = needScores;
        this.needMaxScore = needMaxScore;
        this.needGroupCount = needGroupCount;
    }

    @Override
    public List<Collector> create() throws IOException {
        if (this.firstPhaseGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Collector> collectors = new ArrayList<Collector>();
        this.secondPassCollector = new TermSecondPassGroupingCollector(this.field.getName(), this.firstPhaseGroups, this.groupSort, this.sortWithinGroup, this.maxDocPerGroup, this.needScores, this.needMaxScore, true);
        collectors.add((Collector)this.secondPassCollector);
        if (!this.needGroupCount) {
            return collectors;
        }
        this.allGroupsCollector = new TermAllGroupsCollector(this.field.getName());
        collectors.add((Collector)this.allGroupsCollector);
        return collectors;
    }

    @Override
    public TopGroups<String> result() {
        if (this.firstPhaseGroups.isEmpty()) {
            return new TopGroups(this.groupSort.getSort(), this.sortWithinGroup.getSort(), 0, 0, new GroupDocs[0]);
        }
        TopGroups result = this.secondPassCollector.getTopGroups(0);
        if (this.allGroupsCollector != null) {
            result = new TopGroups(result, Integer.valueOf(this.allGroupsCollector.getGroupCount()));
        }
        return result;
    }

    @Override
    public String getKey() {
        return this.field.getName();
    }

    @Override
    public Sort getGroupSort() {
        return this.groupSort;
    }

    @Override
    public Sort getSortWithinGroup() {
        return this.sortWithinGroup;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private SchemaField field;
        private Sort groupSort;
        private Sort sortWithinGroup;
        private Collection<SearchGroup<String>> firstPhaseGroups;
        private Integer maxDocPerGroup;
        private boolean needScores = false;
        private boolean needMaxScore = false;
        private boolean needGroupCount = false;

        public Builder setField(SchemaField field) {
            this.field = field;
            return this;
        }

        public Builder setGroupSort(Sort groupSort) {
            this.groupSort = groupSort;
            return this;
        }

        public Builder setSortWithinGroup(Sort sortWithinGroup) {
            this.sortWithinGroup = sortWithinGroup;
            return this;
        }

        public Builder setFirstPhaseGroups(Collection<SearchGroup<String>> firstPhaseGroups) {
            this.firstPhaseGroups = firstPhaseGroups;
            return this;
        }

        public Builder setMaxDocPerGroup(int maxDocPerGroup) {
            this.maxDocPerGroup = maxDocPerGroup;
            return this;
        }

        public Builder setNeedScores(Boolean needScores) {
            this.needScores = needScores;
            return this;
        }

        public Builder setNeedMaxScore(Boolean needMaxScore) {
            this.needMaxScore = needMaxScore;
            return this;
        }

        public Builder setNeedGroupCount(Boolean needGroupCount) {
            this.needGroupCount = needGroupCount;
            return this;
        }

        public TopGroupsFieldCommand build() {
            if (this.field == null || this.groupSort == null || this.sortWithinGroup == null || this.firstPhaseGroups == null || this.maxDocPerGroup == null) {
                throw new IllegalStateException("All required fields must be set");
            }
            return new TopGroupsFieldCommand(this.field, this.groupSort, this.sortWithinGroup, this.firstPhaseGroups, this.maxDocPerGroup, this.needScores, this.needMaxScore, this.needGroupCount);
        }
    }
}

