/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.BooleanUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LukeRequestHandler
extends RequestHandlerBase {
    private static Logger log = LoggerFactory.getLogger(LukeRequestHandler.class);
    public static final String NUMTERMS = "numTerms";
    public static final String DOC_ID = "docId";
    public static final String ID = "id";
    public static final String REPORT_DOC_COUNT = "reportDocCount";
    public static final int DEFAULT_COUNT = 10;
    static final int HIST_ARRAY_SIZE = 33;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        IndexSchema schema = req.getSchema();
        SolrIndexSearcher searcher = req.getSearcher();
        SolrIndexReader reader = searcher.getReader();
        SolrParams params = req.getParams();
        int numTerms = params.getInt(NUMTERMS, 10);
        TreeMap<String, TopTermQueue> topTerms = new TreeMap<String, TopTermQueue>();
        TreeSet<String> fields = null;
        String fl = params.get("fl");
        if (fl != null) {
            fields = new TreeSet<String>(Arrays.asList(fl.split("[,\\s]+")));
        }
        if ("schema".equals(params.get("show"))) {
            numTerms = 0;
        }
        rsp.add("index", LukeRequestHandler.getIndexInfo((IndexReader)reader, numTerms, topTerms, fields));
        Integer docId = params.getInt(DOC_ID);
        if (docId == null && params.get(ID) != null) {
            SchemaField uniqueKey = schema.getUniqueKeyField();
            String v = uniqueKey.getType().toInternal(params.get(ID));
            Term t = new Term(uniqueKey.getName(), v);
            docId = searcher.getFirstMatch(t);
            if (docId < 0) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can't find document: " + params.get(ID));
            }
        }
        if (docId != null) {
            Document doc = null;
            try {
                doc = reader.document(docId);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (doc == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can't find document: " + docId);
            }
            SimpleOrderedMap<Object> info = LukeRequestHandler.getDocumentFieldsInfo(doc, docId, (IndexReader)reader, schema);
            SimpleOrderedMap docinfo = new SimpleOrderedMap();
            docinfo.add(DOC_ID, (Object)docId);
            docinfo.add("lucene", info);
            docinfo.add("solr", (Object)doc);
            rsp.add("doc", docinfo);
        } else if ("schema".equals(params.get("show"))) {
            rsp.add("schema", LukeRequestHandler.getSchemaInfo(req.getSchema()));
        } else {
            boolean reportDocCount = true;
            String reportDoc = params.get(REPORT_DOC_COUNT, "false");
            reportDocCount = "1".equals(reportDoc) ? true : ("0".equals(reportDoc) ? false : BooleanUtils.toBoolean((String)reportDoc));
            rsp.add("fields", LukeRequestHandler.getIndexedFieldsInfo(searcher, fields, numTerms, topTerms, reportDocCount));
        }
        SimpleOrderedMap info = new SimpleOrderedMap();
        info.add("key", LukeRequestHandler.getFieldFlagsKey());
        info.add("NOTE", (Object)"Document Frequency (df) is not updated when a document is marked for deletion.  df values include deleted documents.");
        rsp.add("info", info);
        rsp.setHttpCaching(false);
    }

    private static String getFieldFlags(Fieldable f) {
        FieldInfo.IndexOptions opts = f == null ? null : f.getIndexOptions();
        StringBuilder flags = new StringBuilder();
        flags.append(f != null && f.isIndexed() ? FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isTokenized() ? FieldFlag.TOKENIZED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isStored() ? FieldFlag.STORED.getAbbreviation() : (char)'-');
        flags.append('-');
        flags.append(f != null && f.isTermVectorStored() ? FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isStoreOffsetWithTermVector() ? FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isStorePositionWithTermVector() ? FieldFlag.TERM_VECTOR_POSITION.getAbbreviation() : (char)'-');
        flags.append(f != null && f.getOmitNorms() ? FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(f != null && FieldInfo.IndexOptions.DOCS_ONLY == opts ? FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(f != null && FieldInfo.IndexOptions.DOCS_AND_FREQS == opts ? FieldFlag.OMIT_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isLazy() ? FieldFlag.LAZY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.isBinary() ? FieldFlag.BINARY.getAbbreviation() : (char)'-');
        flags.append('-');
        flags.append('-');
        return flags.toString();
    }

    private static String getFieldFlags(SchemaField f) {
        FieldType t = f == null ? null : f.getType();
        boolean lazy = false;
        boolean binary = false;
        StringBuilder flags = new StringBuilder();
        flags.append(f != null && f.indexed() ? FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        flags.append(t != null && t.isTokenized() ? FieldFlag.TOKENIZED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.stored() ? FieldFlag.STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.multiValued() ? FieldFlag.MULTI_VALUED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermVector() ? FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermOffsets() ? FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermPositions() ? FieldFlag.TERM_VECTOR_POSITION.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitNorms() ? FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitTermFreqAndPositions() ? FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitPositions() ? FieldFlag.OMIT_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(lazy ? (char)FieldFlag.LAZY.getAbbreviation() : (char)'-');
        flags.append(binary ? (char)FieldFlag.BINARY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.sortMissingFirst() ? FieldFlag.SORT_MISSING_FIRST.getAbbreviation() : (char)'-');
        flags.append(f != null && f.sortMissingLast() ? FieldFlag.SORT_MISSING_LAST.getAbbreviation() : (char)'-');
        return flags.toString();
    }

    public static SimpleOrderedMap<String> getFieldFlagsKey() {
        SimpleOrderedMap key = new SimpleOrderedMap();
        for (FieldFlag f : FieldFlag.values()) {
            key.add(String.valueOf(f.getAbbreviation()), (Object)f.getDisplay());
        }
        return key;
    }

    private static SimpleOrderedMap<Object> getDocumentFieldsInfo(Document doc, int docId, IndexReader reader, IndexSchema schema) throws IOException {
        SimpleOrderedMap finfo = new SimpleOrderedMap();
        Iterator i$ = doc.getFields().iterator();
        while (i$.hasNext()) {
            Fieldable o;
            Fieldable fieldable = o = (Fieldable)i$.next();
            SimpleOrderedMap f = new SimpleOrderedMap();
            SchemaField sfield = schema.getFieldOrNull(fieldable.name());
            FieldType ftype = sfield == null ? null : sfield.getType();
            f.add("type", (Object)(ftype == null ? null : ftype.getTypeName()));
            f.add("schema", (Object)LukeRequestHandler.getFieldFlags(sfield));
            f.add("flags", (Object)LukeRequestHandler.getFieldFlags(fieldable));
            Term t = new Term(fieldable.name(), ftype != null ? ftype.storedToIndexed(fieldable) : fieldable.stringValue());
            f.add("value", ftype == null ? null : ftype.toExternal(fieldable));
            f.add("internal", (Object)fieldable.stringValue());
            byte[] arr = fieldable.getBinaryValue();
            if (arr != null) {
                f.add("binary", (Object)Base64.byteArrayToBase64((byte[])arr, (int)0, (int)arr.length));
            }
            f.add("boost", (Object)Float.valueOf(fieldable.getBoost()));
            f.add("docFreq", (Object)(t.text() == null ? 0 : reader.docFreq(t)));
            if (fieldable.isTermVectorStored()) {
                try {
                    TermFreqVector v = reader.getTermFreqVector(docId, fieldable.name());
                    if (v != null) {
                        SimpleOrderedMap tfv = new SimpleOrderedMap();
                        for (int i = 0; i < v.size(); ++i) {
                            tfv.add(v.getTerms()[i], (Object)v.getTermFrequencies()[i]);
                        }
                        f.add("termVector", (Object)tfv);
                    }
                }
                catch (Exception ex) {
                    log.warn("error writing term vector", (Throwable)ex);
                }
            }
            finfo.add(fieldable.name(), (Object)f);
        }
        return finfo;
    }

    private static SimpleOrderedMap<Object> getIndexedFieldsInfo(SolrIndexSearcher searcher, Set<String> fields, int numTerms, Map<String, TopTermQueue> ttinfo, boolean reportDocCount) throws Exception {
        SolrIndexReader reader = searcher.getReader();
        IndexSchema schema = searcher.getSchema();
        TreeSet<String> fieldNames = new TreeSet<String>();
        for (FieldInfo fieldInfo : reader.getFieldInfos()) {
            fieldNames.add(fieldInfo.name);
        }
        SimpleOrderedMap finfo = new SimpleOrderedMap();
        for (String fieldName : fieldNames) {
            if (fields != null && !fields.contains(fieldName) && !fields.contains("*")) continue;
            SimpleOrderedMap f = new SimpleOrderedMap();
            SchemaField sfield = schema.getFieldOrNull(fieldName);
            FieldType ftype = sfield == null ? null : sfield.getType();
            f.add("type", (Object)(ftype == null ? null : ftype.getTypeName()));
            f.add("schema", (Object)LukeRequestHandler.getFieldFlags(sfield));
            if (sfield != null && schema.isDynamicField(sfield.getName()) && schema.getDynamicPattern(sfield.getName()) != null) {
                f.add("dynamicBase", (Object)schema.getDynamicPattern(sfield.getName()));
            }
            TopTermQueue topTerms = ttinfo.get(fieldName);
            if (ttinfo != null && sfield != null && sfield.indexed()) {
                if (numTerms > 0) {
                    Document doc = null;
                    int totalHits = 0;
                    if (reportDocCount) {
                        TermRangeQuery q = new TermRangeQuery(fieldName, null, null, false, false);
                        TopDocs top = searcher.search((Query)q, 1);
                        if (top.totalHits > 0) {
                            doc = searcher.doc(top.scoreDocs[0].doc);
                            totalHits = top.totalHits;
                        }
                    } else if (topTerms != null) {
                        TermDocs td = reader.termDocs();
                        td.seek(topTerms.getTopTerm());
                        if (td.next()) {
                            totalHits = 1;
                            doc = reader.document(td.doc());
                        }
                    }
                    if (totalHits > 0) {
                        try {
                            Fieldable fld = doc.getFieldable(fieldName);
                            if (fld != null) {
                                f.add("index", (Object)LukeRequestHandler.getFieldFlags(fld));
                            } else {
                                f.add("index", (Object)"(unstored field)");
                            }
                        }
                        catch (Exception ex) {
                            log.warn("error reading field: " + fieldName);
                        }
                    }
                    if (reportDocCount) {
                        f.add("docs", (Object)totalHits);
                    }
                }
                if (topTerms != null) {
                    f.add("distinct", (Object)topTerms.distinctTerms);
                    f.add("topTerms", topTerms.toNamedList(searcher.getSchema()));
                    f.add("histogram", topTerms.histogram.toNamedList());
                }
            }
            finfo.add(fieldName, (Object)f);
        }
        return finfo;
    }

    private static SimpleOrderedMap<Object> getSchemaInfo(IndexSchema schema) {
        TreeMap<String, List<String>> typeusemap = new TreeMap<String, List<String>>();
        TreeMap<String, Object> fields = new TreeMap<String, Object>();
        SchemaField uniqueField = schema.getUniqueKeyField();
        for (SchemaField f : schema.getFields().values()) {
            LukeRequestHandler.populateFieldInfo(schema, typeusemap, fields, uniqueField, f);
        }
        TreeMap<String, Object> dynamicFields = new TreeMap<String, Object>();
        for (SchemaField f : schema.getDynamicFieldPrototypes()) {
            LukeRequestHandler.populateFieldInfo(schema, typeusemap, dynamicFields, uniqueField, f);
        }
        SimpleOrderedMap types = new SimpleOrderedMap();
        TreeMap<String, FieldType> sortedTypes = new TreeMap<String, FieldType>(schema.getFieldTypes());
        for (FieldType ft : sortedTypes.values()) {
            SimpleOrderedMap field = new SimpleOrderedMap();
            field.add("fields", typeusemap.get(ft.getTypeName()));
            field.add("tokenized", (Object)ft.isTokenized());
            field.add("className", (Object)ft.getClass().getName());
            field.add("indexAnalyzer", LukeRequestHandler.getAnalyzerInfo(ft.getAnalyzer()));
            field.add("queryAnalyzer", LukeRequestHandler.getAnalyzerInfo(ft.getQueryAnalyzer()));
            types.add(ft.getTypeName(), (Object)field);
        }
        SimpleOrderedMap finfo = new SimpleOrderedMap();
        SimpleOrderedMap fieldsSimple = new SimpleOrderedMap();
        for (Map.Entry ent : fields.entrySet()) {
            fieldsSimple.add((String)ent.getKey(), ent.getValue());
        }
        finfo.add("fields", (Object)fieldsSimple);
        SimpleOrderedMap dynamicSimple = new SimpleOrderedMap();
        for (Map.Entry ent : dynamicFields.entrySet()) {
            dynamicSimple.add((String)ent.getKey(), ent.getValue());
        }
        finfo.add("dynamicFields", (Object)dynamicSimple);
        finfo.add("fields", fields);
        finfo.add("dynamicFields", dynamicFields);
        finfo.add("uniqueKeyField", (Object)(null == uniqueField ? null : uniqueField.getName()));
        finfo.add("defaultSearchField", (Object)schema.getDefaultSearchFieldName());
        finfo.add("types", (Object)types);
        return finfo;
    }

    private static SimpleOrderedMap<Object> getAnalyzerInfo(Analyzer analyzer) {
        SimpleOrderedMap aninfo = new SimpleOrderedMap();
        aninfo.add("className", (Object)analyzer.getClass().getName());
        if (analyzer instanceof TokenizerChain) {
            TokenizerChain tchain = (TokenizerChain)analyzer;
            CharFilterFactory[] cfiltfacs = tchain.getCharFilterFactories();
            SimpleOrderedMap cfilters = new SimpleOrderedMap();
            for (CharFilterFactory cfiltfac : cfiltfacs) {
                HashMap<String, Object> tok = new HashMap<String, Object>();
                String className = cfiltfac.getClass().getName();
                tok.put("className", className);
                tok.put("args", cfiltfac.getArgs());
                cfilters.add(className.substring(className.lastIndexOf(46) + 1), tok);
            }
            if (cfilters.size() > 0) {
                aninfo.add("charFilters", (Object)cfilters);
            }
            SimpleOrderedMap tokenizer = new SimpleOrderedMap();
            TokenizerFactory tfac = tchain.getTokenizerFactory();
            tokenizer.add("className", (Object)tfac.getClass().getName());
            tokenizer.add("args", tfac.getArgs());
            aninfo.add("tokenizer", (Object)tokenizer);
            TokenFilterFactory[] filtfacs = tchain.getTokenFilterFactories();
            SimpleOrderedMap filters = new SimpleOrderedMap();
            for (TokenFilterFactory filtfac : filtfacs) {
                HashMap<String, Object> tok = new HashMap<String, Object>();
                String className = filtfac.getClass().getName();
                tok.put("className", className);
                tok.put("args", filtfac.getArgs());
                filters.add(className.substring(className.lastIndexOf(46) + 1), tok);
            }
            if (filters.size() > 0) {
                aninfo.add("filters", (Object)filters);
            }
        }
        return aninfo;
    }

    private static void populateFieldInfo(IndexSchema schema, Map<String, List<String>> typeusemap, Map<String, Object> fields, SchemaField uniqueField, SchemaField f) {
        FieldType ft = f.getType();
        SimpleOrderedMap field = new SimpleOrderedMap();
        field.add("type", (Object)ft.getTypeName());
        field.add("flags", (Object)LukeRequestHandler.getFieldFlags(f));
        if (f.isRequired()) {
            field.add("required", (Object)f.isRequired());
        }
        if (f.getDefaultValue() != null) {
            field.add("default", (Object)f.getDefaultValue());
        }
        if (f == uniqueField) {
            field.add("uniqueKey", (Object)true);
        }
        if (ft.getAnalyzer().getPositionIncrementGap(f.getName()) != 0) {
            field.add("positionIncrementGap", (Object)ft.getAnalyzer().getPositionIncrementGap(f.getName()));
        }
        field.add("copyDests", (Object)schema.getCopyFields(f.getName()));
        field.add("copySources", (Object)schema.getCopySources(f.getName()));
        fields.put(f.getName(), field);
        List<String> v = typeusemap.get(ft.getTypeName());
        if (v == null) {
            v = new ArrayList<String>();
        }
        v.add(f.getName());
        typeusemap.put(ft.getTypeName(), v);
    }

    public static SimpleOrderedMap<Object> getIndexInfo(IndexReader reader, boolean countTerms) throws IOException {
        return LukeRequestHandler.getIndexInfo(reader, countTerms ? 1 : 0, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SimpleOrderedMap<Object> getIndexInfo(IndexReader reader, int numTerms, Map<String, TopTermQueue> topTerms, Set<String> fields) throws IOException {
        SimpleOrderedMap indexInfo;
        Directory dir;
        block9: {
            dir = reader.directory();
            indexInfo = new SimpleOrderedMap();
            indexInfo.add("numDocs", (Object)reader.numDocs());
            indexInfo.add("maxDoc", (Object)reader.maxDoc());
            if (numTerms > 0) {
                TermEnum terms = null;
                try {
                    terms = reader.terms();
                    int totalUniqueTerms = 0;
                    String lastField = "";
                    int[] buckets = new int[33];
                    TopTermQueue tiq = null;
                    String field = "";
                    while (terms.next()) {
                        ++totalUniqueTerms;
                        field = terms.term().field();
                        if (!field.equals(lastField)) {
                            if (tiq != null) {
                                tiq.histogram.add(buckets);
                                topTerms.put(lastField, tiq);
                                tiq = null;
                            }
                            lastField = field;
                            if (fields != null && !fields.contains(field) && !fields.contains("*")) continue;
                            tiq = new TopTermQueue(numTerms + 1);
                            for (int idx = 0; idx < buckets.length; ++idx) {
                                buckets[idx] = 0;
                            }
                        }
                        if (tiq == null) continue;
                        int freq = terms.docFreq();
                        int slot = 32 - Integer.numberOfLeadingZeros(Math.max(0, freq - 1));
                        buckets[slot] = buckets[slot] + 1;
                        ++tiq.distinctTerms;
                        if (terms.docFreq() <= tiq.minFreq) continue;
                        tiq.add(new TopTermQueue.TermInfo(terms.term(), terms.docFreq()));
                        if (tiq.size() <= numTerms) continue;
                        tiq.pop();
                        tiq.minFreq = ((TopTermQueue.TermInfo)tiq.top()).docFreq;
                    }
                    if (tiq != null) {
                        tiq.histogram.add(buckets);
                        topTerms.put(field, tiq);
                    }
                    indexInfo.add(NUMTERMS, (Object)totalUniqueTerms);
                    Object var15_14 = null;
                    if (terms == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var15_15 = null;
                    if (terms != null) {
                        terms.close();
                    }
                    throw throwable;
                }
                terms.close();
            }
        }
        indexInfo.add("version", (Object)reader.getVersion());
        indexInfo.add("segmentCount", (Object)reader.getSequentialSubReaders().length);
        indexInfo.add("current", (Object)reader.isCurrent());
        indexInfo.add("hasDeletions", (Object)reader.hasDeletions());
        indexInfo.add("directory", (Object)dir);
        indexInfo.add("lastModified", (Object)new Date(IndexReader.lastModified((Directory)dir)));
        return indexInfo;
    }

    @Override
    public String getDescription() {
        return "Lucene Index Browser.  Inspired and modeled after Luke: http://www.getopt.org/luke/";
    }

    @Override
    public String getVersion() {
        return "$Revision: 1242152 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: LukeRequestHandler.java 1242152 2012-02-08 22:31:07Z erick $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_3x/solr/core/src/java/org/apache/solr/handler/admin/LukeRequestHandler.java $";
    }

    @Override
    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/LukeRequestHandler")};
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TopTermQueue
    extends PriorityQueue {
        public int minFreq = 0;
        public int distinctTerms = 0;
        public TermHistogram histogram;

        TopTermQueue(int size) {
            this.initialize(size);
            this.histogram = new TermHistogram();
        }

        protected final boolean lessThan(Object a, Object b) {
            TermInfo termInfoA = (TermInfo)a;
            TermInfo termInfoB = (TermInfo)b;
            return termInfoA.docFreq < termInfoB.docFreq;
        }

        public NamedList<Integer> toNamedList(IndexSchema schema) {
            LinkedList<TermInfo> aslist = new LinkedList<TermInfo>();
            while (this.size() > 0) {
                aslist.add(0, (TermInfo)this.pop());
            }
            NamedList list = new NamedList();
            for (TermInfo i : aslist) {
                String txt = i.term.text();
                SchemaField ft = schema.getFieldOrNull(i.term.field());
                if (ft != null) {
                    txt = ft.getType().indexedToReadable(txt);
                }
                list.add(txt, (Object)i.docFreq);
            }
            return list;
        }

        public Term getTopTerm() {
            return ((TermInfo)this.top()).term;
        }

        static class TermInfo {
            int docFreq;
            Term term;

            TermInfo(Term t, int df) {
                this.term = t;
                this.docFreq = df;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TermHistogram {
        int _maxBucket = -1;
        int[] _buckets = new int[33];

        TermHistogram() {
        }

        public void add(int[] buckets) {
            int idx;
            for (idx = 0; idx < buckets.length; ++idx) {
                if (buckets[idx] == 0) continue;
                this._maxBucket = idx;
            }
            for (idx = 0; idx <= this._maxBucket; ++idx) {
                this._buckets[idx] = buckets[idx];
            }
        }

        public NamedList<Integer> toNamedList() {
            NamedList nl = new NamedList();
            for (int bucket = 0; bucket <= this._maxBucket; ++bucket) {
                nl.add("" + (1 << bucket), (Object)this._buckets[bucket]);
            }
            return nl;
        }
    }
}

