/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.net.URL;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.handler.admin.PluginInfoHandler;
import org.apache.solr.handler.admin.PropertiesRequestHandler;
import org.apache.solr.handler.admin.ShowFileRequestHandler;
import org.apache.solr.handler.admin.SolrInfoMBeanHandler;
import org.apache.solr.handler.admin.SystemInfoHandler;
import org.apache.solr.handler.admin.ThreadDumpHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;

public class AdminHandlers
implements SolrCoreAware,
SolrRequestHandler {
    NamedList initArgs = null;

    public void init(NamedList args) {
        this.initArgs = args;
    }

    public void inform(SolrCore core) {
        StandardHandler[] list;
        String path = null;
        for (Map.Entry<String, SolrRequestHandler> entry : core.getRequestHandlers().entrySet()) {
            if (entry.getValue() != this) continue;
            path = entry.getKey();
            break;
        }
        if (path == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The AdminHandler is not registered with the current core.");
        }
        if (!path.startsWith("/")) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The AdminHandler needs to be registered to a path.  Typically this is '/admin'");
        }
        core.registerRequestHandler(path, null);
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        for (StandardHandler handler : list = new StandardHandler[]{new StandardHandler("luke", new LukeRequestHandler()), new StandardHandler("system", new SystemInfoHandler()), new StandardHandler("mbeans", new SolrInfoMBeanHandler()), new StandardHandler("plugins", new PluginInfoHandler()), new StandardHandler("threads", new ThreadDumpHandler()), new StandardHandler("properties", new PropertiesRequestHandler()), new StandardHandler("file", new ShowFileRequestHandler())}) {
            if (core.getRequestHandler(path + handler.name) != null) continue;
            handler.handler.init(this.initArgs);
            core.registerRequestHandler(path + handler.name, handler.handler);
            if (!(handler.handler instanceof SolrCoreAware)) continue;
            ((SolrCoreAware)((Object)handler)).inform(core);
        }
    }

    public void handleRequest(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The AdminHandler should never be called directly");
    }

    public String getDescription() {
        return "Register Standard Admin Handlers";
    }

    public String getVersion() {
        return "$Revision: 953887 $";
    }

    public String getSourceId() {
        return "$Id: AdminHandlers.java 953887 2010-06-11 21:53:43Z hossman $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_3x/solr/core/src/java/org/apache/solr/handler/admin/AdminHandlers.java $";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.QUERYHANDLER;
    }

    public URL[] getDocs() {
        return null;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public NamedList getStatistics() {
        return null;
    }

    private static class StandardHandler {
        final String name;
        final SolrRequestHandler handler;

        public StandardHandler(String n, SolrRequestHandler h) {
            this.name = n;
            this.handler = h;
        }
    }
}

