/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class DumpRequestHandler
extends RequestHandlerBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        rsp.add("params", req.getParams().toNamedList());
        if (req.getContentStreams() != null) {
            ArrayList<SimpleOrderedMap> streams = new ArrayList<SimpleOrderedMap>();
            for (ContentStream content : req.getContentStreams()) {
                Object var9_8;
                SimpleOrderedMap stream = new SimpleOrderedMap();
                stream.add("name", (Object)content.getName());
                stream.add("sourceInfo", (Object)content.getSourceInfo());
                stream.add("size", (Object)content.getSize());
                stream.add("contentType", (Object)content.getContentType());
                Reader reader = content.getReader();
                try {
                    stream.add("stream", (Object)IOUtils.toString((Reader)reader));
                    var9_8 = null;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    reader.close();
                    throw throwable;
                }
                reader.close();
                streams.add(stream);
            }
            rsp.add("streams", streams);
        }
        rsp.add("context", req.getContext());
    }

    public String getDescription() {
        return "Dump handler (debug)";
    }

    public String getVersion() {
        return "$Revision: 1067172 $";
    }

    public String getSourceId() {
        return "$Id: DumpRequestHandler.java 1067172 2011-02-04 12:50:14Z uschindler $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_3x/solr/core/src/java/org/apache/solr/handler/DumpRequestHandler.java $";
    }
}

