/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.solr.client.solrj.request.JavaBinUpdateRequestCodec;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class BinaryUpdateRequestHandler
extends ContentStreamHandlerBase {
    protected ContentStreamLoader newLoader(SolrQueryRequest req, final UpdateRequestProcessor processor) {
        return new ContentStreamLoader(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream) throws Exception {
                InputStream is = null;
                try {
                    is = stream.getStream();
                    BinaryUpdateRequestHandler.this.parseAndLoadDocs(req, rsp, is, processor);
                    Object var6_5 = null;
                    if (is == null) return;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
            }
        };
    }

    private void parseAndLoadDocs(SolrQueryRequest req, SolrQueryResponse rsp, InputStream stream, final UpdateRequestProcessor processor) throws IOException {
        UpdateRequest update = null;
        JavaBinUpdateRequestCodec.StreamingUpdateHandler handler = new JavaBinUpdateRequestCodec.StreamingUpdateHandler(){
            private AddUpdateCommand addCmd = null;

            public void update(SolrInputDocument document, UpdateRequest updateRequest) {
                if (document == null) {
                    try {
                        RequestHandlerUtils.handleCommit(processor, (SolrParams)updateRequest.getParams(), false);
                        RequestHandlerUtils.handleRollback(processor, (SolrParams)updateRequest.getParams(), false);
                    }
                    catch (IOException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ERROR handling commit/rollback");
                    }
                    return;
                }
                if (this.addCmd == null) {
                    this.addCmd = BinaryUpdateRequestHandler.this.getAddCommand((SolrParams)updateRequest.getParams());
                }
                this.addCmd.solrDoc = document;
                try {
                    processor.processAdd(this.addCmd);
                    this.addCmd.clear();
                }
                catch (IOException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "ERROR adding document " + document);
                }
            }
        };
        FastInputStream in = FastInputStream.wrap((InputStream)stream);
        while (true) {
            try {
                update = new JavaBinUpdateRequestCodec().unmarshal((InputStream)in, handler);
            }
            catch (EOFException e) {
                break;
            }
            catch (Exception e) {
                log.error("Exception while processing update request", (Throwable)e);
                break;
            }
            if (update.getDeleteById() == null && update.getDeleteQuery() == null) continue;
            this.delete(update, processor);
        }
    }

    private AddUpdateCommand getAddCommand(SolrParams params) {
        AddUpdateCommand addCmd = new AddUpdateCommand();
        boolean overwrite = true;
        overwrite = params.getBool("overwrite", overwrite);
        addCmd.commitWithin = params.getInt("commitWithin", -1);
        addCmd.overwriteCommitted = overwrite;
        addCmd.overwritePending = overwrite;
        addCmd.allowDups = !overwrite;
        return addCmd;
    }

    private void delete(UpdateRequest update, UpdateRequestProcessor processor) throws IOException {
        String s;
        Iterator i$;
        ModifiableSolrParams params = update.getParams();
        DeleteUpdateCommand delcmd = new DeleteUpdateCommand();
        delcmd.fromCommitted = true;
        delcmd.fromPending = true;
        if (params != null) {
            delcmd.commitWithin = params.getInt("commitWithin", -1);
        }
        if (update.getDeleteById() != null) {
            i$ = update.getDeleteById().iterator();
            while (i$.hasNext()) {
                delcmd.id = s = (String)i$.next();
                processor.processDelete(delcmd);
            }
            delcmd.id = null;
        }
        if (update.getDeleteQuery() != null) {
            i$ = update.getDeleteQuery().iterator();
            while (i$.hasNext()) {
                delcmd.query = s = (String)i$.next();
                processor.processDelete(delcmd);
            }
        }
    }

    public String getDescription() {
        return "Add/Update multiple documents with javabin format";
    }

    public String getSourceId() {
        return "$Id: BinaryUpdateRequestHandler.java 1235304 2012-01-24 15:39:17Z janhoy $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/branch_3x/solr/core/src/java/org/apache/solr/handler/BinaryUpdateRequestHandler.java $";
    }

    public String getVersion() {
        return "$Revision: 1235304 $";
    }
}

