/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.collation.ICUCollationKeyAnalyzer;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocTermOrdsRangeFilter;
import org.apache.lucene.search.FieldCacheRangeFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public class ICUCollationField
extends FieldType {
    private Analyzer analyzer;

    protected void init(IndexSchema schema, Map<String, String> args) {
        this.properties |= 2;
        this.setup((ResourceLoader)schema.getResourceLoader(), args);
        super.init(schema, args);
    }

    private void setup(ResourceLoader loader, Map<String, String> args) {
        String custom = args.remove("custom");
        String localeID = args.remove("locale");
        String strength = args.remove("strength");
        String decomposition = args.remove("decomposition");
        String alternate = args.remove("alternate");
        String caseLevel = args.remove("caseLevel");
        String caseFirst = args.remove("caseFirst");
        String numeric = args.remove("numeric");
        String variableTop = args.remove("variableTop");
        if (custom == null && localeID == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Either custom or locale is required.");
        }
        if (custom != null && localeID != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot specify both locale and custom. To tailor rules for a built-in language, see the javadocs for RuleBasedCollator. Then save the entire customized ruleset to a file, and use with the custom parameter");
        }
        Collator collator = localeID != null ? this.createFromLocale(localeID) : this.createFromRules(custom, loader);
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("quaternary")) {
                collator.setStrength(3);
            } else if (strength.equalsIgnoreCase("identical")) {
                collator.setStrength(15);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid strength: " + strength);
            }
        }
        if (decomposition != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                collator.setDecomposition(16);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                collator.setDecomposition(17);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid decomposition: " + decomposition);
            }
        }
        RuleBasedCollator rbc = (RuleBasedCollator)collator;
        if (alternate != null) {
            if (alternate.equalsIgnoreCase("shifted")) {
                rbc.setAlternateHandlingShifted(true);
            } else if (alternate.equalsIgnoreCase("non-ignorable")) {
                rbc.setAlternateHandlingShifted(false);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid alternate: " + alternate);
            }
        }
        if (caseLevel != null) {
            rbc.setCaseLevel(Boolean.parseBoolean(caseLevel));
        }
        if (caseFirst != null) {
            if (caseFirst.equalsIgnoreCase("lower")) {
                rbc.setLowerCaseFirst(true);
            } else if (caseFirst.equalsIgnoreCase("upper")) {
                rbc.setUpperCaseFirst(true);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid caseFirst: " + caseFirst);
            }
        }
        if (numeric != null) {
            rbc.setNumericCollation(Boolean.parseBoolean(numeric));
        }
        if (variableTop != null) {
            rbc.setVariableTop(variableTop);
        }
        this.analyzer = new ICUCollationKeyAnalyzer(Version.LUCENE_CURRENT, collator);
    }

    private Collator createFromLocale(String localeID) {
        return Collator.getInstance((ULocale)new ULocale(localeID));
    }

    private Collator createFromRules(String fileName, ResourceLoader loader) {
        InputStream input = null;
        try {
            input = loader.openResource(fileName);
            String rules = IOUtils.toString((InputStream)input, (String)"UTF-8");
            RuleBasedCollator ruleBasedCollator = new RuleBasedCollator(rules);
            return ruleBasedCollator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    public SortField getSortField(SchemaField field, boolean top) {
        return this.getStringSort(field, top);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.analyzer;
    }

    private BytesRef getCollationKey(String field, String text) {
        BytesRef bytesRef;
        TokenStream source = null;
        try {
            source = this.analyzer.tokenStream(field, text);
            source.reset();
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)source.getAttribute(TermToBytesRefAttribute.class);
            BytesRef bytes = termAtt.getBytesRef();
            if (!source.incrementToken()) {
                throw new IllegalArgumentException("analyzer returned no terms for text: " + text);
            }
            termAtt.fillBytesRef();
            assert (!source.incrementToken());
            source.end();
            bytesRef = BytesRef.deepCopyOf((BytesRef)bytes);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unable to analyze text: " + text, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(source);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)source);
        return bytesRef;
    }

    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        BytesRef high;
        String f = field.getName();
        BytesRef low = part1 == null ? null : this.getCollationKey(f, part1);
        BytesRef bytesRef = high = part2 == null ? null : this.getCollationKey(f, part2);
        if (!field.indexed() && field.hasDocValues()) {
            if (field.multiValued()) {
                return new ConstantScoreQuery((Filter)DocTermOrdsRangeFilter.newBytesRefRange((String)field.getName(), (BytesRef)low, (BytesRef)high, (boolean)minInclusive, (boolean)maxInclusive));
            }
            return new ConstantScoreQuery((Filter)FieldCacheRangeFilter.newBytesRefRange((String)field.getName(), (BytesRef)low, (BytesRef)high, (boolean)minInclusive, (boolean)maxInclusive));
        }
        return new TermRangeQuery(field.getName(), low, high, minInclusive, maxInclusive);
    }

    public void checkSchemaField(SchemaField field) {
    }

    public List<IndexableField> createFields(SchemaField field, Object value, float boost) {
        if (field.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            fields.add(this.createField(field, value, boost));
            BytesRef bytes = this.getCollationKey(field.getName(), value.toString());
            if (field.multiValued()) {
                fields.add((IndexableField)new SortedSetDocValuesField(field.getName(), bytes));
            } else {
                fields.add((IndexableField)new SortedDocValuesField(field.getName(), bytes));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(field, value, boost));
    }

    public Object marshalSortValue(Object value) {
        return ICUCollationField.marshalBase64SortValue((Object)value);
    }

    public Object unmarshalSortValue(Object value) {
        return ICUCollationField.unmarshalBase64SortValue((Object)value);
    }
}

