/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.UnsupportedImplementationException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.PassThroughOperation;
import org.opengis.referencing.operation.SingleOperation;

@XmlType(name="PassThroughOperationType", propOrder={"indices", "operation"})
@XmlRootElement(name="PassThroughOperation")
public class DefaultPassThroughOperation
extends AbstractCoordinateOperation
implements PassThroughOperation {
    private static final long serialVersionUID = 4308173919747248695L;
    private SingleOperation operation;

    public DefaultPassThroughOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, SingleOperation singleOperation, int n, int n2) {
        super(map, coordinateReferenceSystem, coordinateReferenceSystem2, null, PassThroughTransform.create(n, singleOperation.getMathTransform(), n2));
        ArgumentChecks.ensureNonNull((String)"operation", (Object)singleOperation);
        this.operation = singleOperation;
    }

    protected DefaultPassThroughOperation(PassThroughOperation passThroughOperation) {
        super((CoordinateOperation)passThroughOperation);
        this.operation = passThroughOperation.getOperation();
    }

    public static DefaultPassThroughOperation castOrCopy(PassThroughOperation passThroughOperation) {
        return passThroughOperation == null || passThroughOperation instanceof DefaultPassThroughOperation ? (DefaultPassThroughOperation)passThroughOperation : new DefaultPassThroughOperation(passThroughOperation);
    }

    public Class<? extends PassThroughOperation> getInterface() {
        return PassThroughOperation.class;
    }

    @Override
    @Deprecated
    public OperationMethod getMethod() {
        return null;
    }

    @Override
    @Deprecated
    public ParameterValueGroup getParameterValues() {
        return null;
    }

    @XmlElement(name="coordOperation", required=true)
    public SingleOperation getOperation() {
        return this.operation;
    }

    public int[] getModifiedCoordinates() {
        MathTransform mathTransform = super.getMathTransform();
        if (mathTransform instanceof PassThroughTransform) {
            return ((PassThroughTransform)mathTransform).getModifiedCoordinates();
        }
        CoordinateReferenceSystem coordinateReferenceSystem = super.getSourceCRS();
        if (coordinateReferenceSystem instanceof CompoundCRS) {
            int n = 0;
            CoordinateReferenceSystem coordinateReferenceSystem2 = this.operation.getSourceCRS();
            for (CoordinateReferenceSystem coordinateReferenceSystem3 : ((CompoundCRS)coordinateReferenceSystem).getComponents()) {
                int n2 = ReferencingUtilities.getDimension(coordinateReferenceSystem3);
                if (coordinateReferenceSystem3 == coordinateReferenceSystem2) {
                    int[] nArray = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        nArray[i] = n + i;
                    }
                    return nArray;
                }
                n += n2;
            }
        }
        throw new UnsupportedImplementationException(mathTransform.getClass());
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            if (comparisonMode == ComparisonMode.STRICT) {
                return Objects.equals(this.operation, ((DefaultPassThroughOperation)object).operation);
            }
            return Utilities.deepEquals((Object)this.getOperation(), (Object)((PassThroughOperation)object).getOperation(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(31 * this.operation.hashCode());
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        formatter.append(new FormattableObject(){

            protected String formatTo(Formatter formatter) {
                for (int n : DefaultPassThroughOperation.this.getModifiedCoordinates()) {
                    formatter.append((long)n);
                }
                return "ModifiedCoordinates";
            }
        });
        formatter.newLine();
        formatter.append((FormattableObject)DefaultPassThroughOperation.castOrCopy((CoordinateOperation)this.getOperation()));
        formatter.setInvalidWKT((IdentifiedObject)this, null);
        return "PassThroughOperation";
    }

    private DefaultPassThroughOperation() {
    }

    private void setOperation(SingleOperation singleOperation) {
        if (this.operation == null) {
            this.operation = singleOperation;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultPassThroughOperation.class, (String)"setOperation", (String)"coordOperation");
        }
    }

    @XmlElement(name="modifiedCoordinate", required=true)
    private int[] getIndices() {
        int[] nArray = this.getModifiedCoordinates();
        int n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        return nArray;
    }

    private void setIndices(int[] nArray) {
        String string = "sourceCRS";
        CoordinateReferenceSystem coordinateReferenceSystem = super.getSourceCRS();
        if (coordinateReferenceSystem != null) {
            string = "modifiedCoordinate";
            if (nArray != null && nArray.length != 0) {
                string = "coordOperation";
                if (this.operation != null) {
                    for (int i = 1; i < nArray.length; ++i) {
                        int n = nArray[i - 1];
                        if (n >= 1 && nArray[i] == n + 1) continue;
                        throw new IllegalArgumentException(Errors.format((short)4, (Object)string, (Object)Arrays.toString(nArray)));
                    }
                    this.transform = PassThroughTransform.create(nArray[0] - 1, this.operation.getMathTransform(), ReferencingUtilities.getDimension(coordinateReferenceSystem) - nArray[nArray.length - 1]);
                    return;
                }
            }
        }
        throw new IllegalStateException(Errors.format((short)85, (Object)string, (Object)"PassThroughOperation"));
    }
}

