/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Map;
import java.util.Objects;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.internal.jaxb.gml.Measure;
import org.apache.sis.internal.jaxb.referencing.SecondDefiningParameter;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.Sphere;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Ellipsoid;

@XmlType(name="EllipsoidType", propOrder={"semiMajorAxisMeasure", "secondDefiningParameter"})
@XmlRootElement(name="Ellipsoid")
public class DefaultEllipsoid
extends AbstractIdentifiedObject
implements Ellipsoid {
    private static final long serialVersionUID = -1149451543954764081L;
    private static final int MAX_ITERATIONS = 100;
    private static final double EPS = 5.0E-14;
    private static final double COMPARISON_THRESHOLD = 1.0E-10;
    private double semiMajorAxis;
    private double semiMinorAxis;
    private double inverseFlattening;
    private boolean ivfDefinitive;
    private Unit<Length> unit;

    protected DefaultEllipsoid(Map<String, ?> map, double d, double d2, double d3, boolean bl, Unit<Length> unit) {
        super(map);
        ArgumentChecks.ensureNonNull((String)"unit", unit);
        ArgumentChecks.ensureStrictlyPositive((String)"semiMajorAxis", (double)d);
        ArgumentChecks.ensureStrictlyPositive((String)"semiMinorAxis", (double)d2);
        ArgumentChecks.ensureStrictlyPositive((String)"inverseFlattening", (double)d3);
        this.unit = unit;
        this.semiMajorAxis = d;
        this.semiMinorAxis = d2;
        this.inverseFlattening = d3;
        this.ivfDefinitive = bl;
    }

    protected DefaultEllipsoid(Ellipsoid ellipsoid) {
        super((IdentifiedObject)ellipsoid);
        this.semiMajorAxis = ellipsoid.getSemiMajorAxis();
        this.semiMinorAxis = ellipsoid.getSemiMinorAxis();
        this.inverseFlattening = ellipsoid.getInverseFlattening();
        this.ivfDefinitive = ellipsoid.isIvfDefinitive();
        this.unit = ellipsoid.getAxisUnit();
    }

    public static DefaultEllipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (d == d2) {
            return new Sphere(map, d, false, unit);
        }
        return new DefaultEllipsoid(map, d, d2, Formulas.getInverseFlattening(d, d2), false, unit);
    }

    public static DefaultEllipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) {
        if (Double.isInfinite(d2)) {
            return new Sphere(map, d, true, unit);
        }
        return new DefaultEllipsoid(map, d, Formulas.getSemiMinor(d, d2), d2, true, unit);
    }

    public static DefaultEllipsoid castOrCopy(Ellipsoid ellipsoid) {
        if (ellipsoid == null || ellipsoid instanceof DefaultEllipsoid) {
            return (DefaultEllipsoid)ellipsoid;
        }
        Map<String, ?> map = IdentifiedObjects.getProperties((IdentifiedObject)ellipsoid, new String[0]);
        double d = ellipsoid.getSemiMajorAxis();
        Unit unit = ellipsoid.getAxisUnit();
        return ellipsoid.isIvfDefinitive() ? DefaultEllipsoid.createFlattenedSphere(map, d, ellipsoid.getInverseFlattening(), (Unit<Length>)unit) : DefaultEllipsoid.createEllipsoid(map, d, ellipsoid.getSemiMinorAxis(), (Unit<Length>)unit);
    }

    public Class<? extends Ellipsoid> getInterface() {
        return Ellipsoid.class;
    }

    public Unit<Length> getAxisUnit() {
        return this.unit;
    }

    public double getSemiMajorAxis() {
        return this.semiMajorAxis;
    }

    public double getSemiMinorAxis() {
        return this.semiMinorAxis;
    }

    public double getAuthalicRadius() {
        return Formulas.getAuthalicRadius(this.getSemiMajorAxis(), this.getSemiMinorAxis());
    }

    public double getEccentricity() {
        DoubleDouble doubleDouble = this.eccentricitySquared();
        doubleDouble.sqrt();
        return doubleDouble.value;
    }

    public double getEccentricitySquared() {
        return this.eccentricitySquared().value;
    }

    private DoubleDouble eccentricitySquared() {
        DoubleDouble doubleDouble = DefaultEllipsoid.flattening(this);
        DoubleDouble doubleDouble2 = new DoubleDouble(doubleDouble);
        doubleDouble2.multiply(2.0, 0.0);
        doubleDouble.square();
        doubleDouble2.subtract(doubleDouble);
        return doubleDouble2;
    }

    private static DoubleDouble flattening(Ellipsoid ellipsoid) {
        DoubleDouble doubleDouble;
        if (ellipsoid.isIvfDefinitive()) {
            doubleDouble = new DoubleDouble(ellipsoid.getInverseFlattening());
            doubleDouble.inverseDivide(1.0, 0.0);
        } else {
            doubleDouble = new DoubleDouble(ellipsoid.getSemiMajorAxis());
            double d = doubleDouble.value;
            double d2 = doubleDouble.error;
            doubleDouble.subtract(ellipsoid.getSemiMinorAxis());
            doubleDouble.divide(d, d2);
        }
        return doubleDouble;
    }

    public double getInverseFlattening() {
        return this.inverseFlattening;
    }

    public boolean isIvfDefinitive() {
        return this.ivfDefinitive;
    }

    public boolean isSphere() {
        return this.semiMajorAxis == this.semiMinorAxis;
    }

    public double orthodromicDistance(double d, double d2, double d3, double d4) {
        d = Math.toRadians(d);
        d2 = Math.toRadians(d2);
        d3 = Math.toRadians(d3);
        d4 = Math.toRadians(d4);
        double d5 = 1.0 / this.getInverseFlattening();
        double d6 = 1.0 - d5;
        double d7 = d6 * Math.tan(d2);
        double d8 = d6 * Math.tan(d4);
        double d9 = 1.0 / Math.sqrt(d7 * d7 + 1.0);
        double d10 = 1.0 / Math.sqrt(d8 * d8 + 1.0);
        double d11 = d9 * d7;
        double d12 = d9 * d10;
        double d13 = d12 * d8;
        double d14 = d13 * d7;
        double d15 = d3 - d;
        for (int i = 0; i < 100; ++i) {
            double d16 = Math.sin(d15);
            double d17 = Math.cos(d15);
            d7 = d10 * d16;
            d8 = d13 - d11 * d10 * d17;
            double d18 = Math.hypot(d7, d8);
            double d19 = d12 * d17 + d14;
            double d20 = Math.atan2(d18, d19);
            double d21 = d12 * (d16 / d18);
            double d22 = 1.0 - d21 * d21;
            double d23 = 2.0 * d14;
            if (d22 > 0.0) {
                d23 = -d23 / d22 + d19;
            }
            double d24 = d23 * d23 * 2.0 - 1.0;
            double d25 = ((-3.0 * d22 + 4.0) * d5 + 4.0) * d22 * d5 / 16.0;
            double d26 = d15;
            d15 = ((d24 * d19 * d25 + d23) * d18 * d25 + d20) * d21;
            if (!(Math.abs(d26 - (d15 = (1.0 - d25) * d15 * d5 + d3 - d)) <= 5.0E-14)) continue;
            d15 = Math.sqrt((1.0 / (d6 * d6) - 1.0) * d22 + 1.0) + 1.0;
            d15 = (d15 - 2.0) / d15;
            d25 = 1.0 - d15;
            d25 = (d15 * d15 / 4.0 + 1.0) / d25;
            d26 = (0.375 * d15 * d15 - 1.0) * d15;
            d15 = d24 * d19;
            d12 = 1.0 - 2.0 * d24;
            d12 = ((((d18 * d18 * 4.0 - 3.0) * d12 * d23 * d26 / 6.0 - d15) * d26 / 4.0 + d23) * d18 * d26 + d20) * d25 * d6 * this.getSemiMajorAxis();
            return d12;
        }
        if (Math.abs(d - d3) <= 1.0E-10 && Math.abs(d2 - d4) <= 1.0E-10) {
            return 0.0;
        }
        if (Math.abs(d2) <= 1.0E-10 && Math.abs(d4) <= 1.0E-10) {
            return Math.abs(d - d3) * this.getSemiMajorAxis();
        }
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4)) {
            return Double.NaN;
        }
        throw new ArithmeticException(Resources.format((short)47, new DirectPosition2D(Math.toDegrees(d), Math.toDegrees(d2)), new DirectPosition2D(Math.toDegrees(d3), Math.toDegrees(d4))));
    }

    public double semiMajorAxisDifference(Ellipsoid ellipsoid) {
        double d = ellipsoid.getSemiMajorAxis();
        d = ellipsoid.getAxisUnit().getConverterTo(this.getAxisUnit()).convert(d);
        DoubleDouble doubleDouble = new DoubleDouble(d);
        doubleDouble.subtract(this.getSemiMajorAxis());
        return doubleDouble.value;
    }

    public double flatteningDifference(Ellipsoid ellipsoid) {
        DoubleDouble doubleDouble = DefaultEllipsoid.flattening(ellipsoid);
        doubleDouble.subtract(DefaultEllipsoid.flattening(this));
        return doubleDouble.value;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                DefaultEllipsoid defaultEllipsoid = (DefaultEllipsoid)object;
                return this.ivfDefinitive == defaultEllipsoid.ivfDefinitive && Numerics.equals((double)this.semiMajorAxis, (double)defaultEllipsoid.semiMajorAxis) && Numerics.equals((double)this.semiMinorAxis, (double)defaultEllipsoid.semiMinorAxis) && Numerics.equals((double)this.inverseFlattening, (double)defaultEllipsoid.inverseFlattening) && Objects.equals(this.unit, defaultEllipsoid.unit);
            }
            case BY_CONTRACT: {
                if (this.isIvfDefinitive() != ((Ellipsoid)object).isIvfDefinitive()) {
                    return false;
                }
            }
            case IGNORE_METADATA: {
                if (Numerics.equals((double)this.getInverseFlattening(), (double)((Ellipsoid)object).getInverseFlattening())) break;
                return false;
            }
        }
        Ellipsoid ellipsoid = (Ellipsoid)object;
        Unit<Length> unit = this.getAxisUnit();
        if (!Utilities.deepEquals(unit, (Object)ellipsoid.getAxisUnit(), (ComparisonMode)comparisonMode)) {
            return false;
        }
        UnitConverter unitConverter = comparisonMode.isApproximative() ? unit.getConverterTo(Units.METRE) : null;
        boolean bl = false;
        double d = this.getSemiMajorAxis();
        double d2 = ellipsoid.getSemiMajorAxis();
        if (unitConverter == null ? Numerics.equals((double)d, (double)d2) : Numerics.epsilonEqual((double)unitConverter.convert(d), (double)unitConverter.convert(d2), (double)0.01)) {
            bl = true;
            d = this.getSemiMinorAxis();
            d2 = ellipsoid.getSemiMinorAxis();
            if (unitConverter == null ? Numerics.equals((double)d, (double)d2) : Numerics.epsilonEqual((double)unitConverter.convert(d), (double)unitConverter.convert(d2), (double)0.01)) {
                return true;
            }
        }
        assert (comparisonMode != ComparisonMode.DEBUG) : Numerics.messageForDifference((String)(bl ? "semiMinorAxis" : "semiMajorAxis"), (double)d, (double)d2);
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + Double.doubleToLongBits(this.semiMajorAxis) + 31L * Double.doubleToLongBits(this.ivfDefinitive ? this.inverseFlattening : this.semiMinorAxis);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        Unit<Length> unit = this.getAxisUnit();
        double d = this.getSemiMajorAxis();
        if (bl) {
            d = unit.getConverterTo(Units.METRE).convert(d);
        }
        formatter.append(d);
        double d2 = this.getInverseFlattening();
        formatter.append(Double.isInfinite(d2) ? 0.0 : d2);
        if (bl) {
            return "Spheroid";
        }
        if (!convention.isSimplified() || !Units.METRE.equals(unit)) {
            formatter.append(unit);
        }
        return "Ellipsoid";
    }

    private DefaultEllipsoid() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        if (this.ivfDefinitive) {
            if (this.semiMinorAxis == 0.0) {
                this.semiMinorAxis = Formulas.getSemiMinor(this.semiMajorAxis, this.inverseFlattening);
            }
        } else if (this.inverseFlattening == 0.0) {
            this.inverseFlattening = Formulas.getInverseFlattening(this.semiMajorAxis, this.semiMinorAxis);
        } else if (this.inverseFlattening == Double.POSITIVE_INFINITY && this.semiMinorAxis == 0.0) {
            this.semiMinorAxis = this.semiMajorAxis;
        }
        if (this.unit == null) {
            this.unit = Units.METRE;
            Measure.missingUOM(DefaultEllipsoid.class, (String)"semiMajorAxis");
        }
    }

    @XmlElement(name="semiMajorAxis", required=true)
    private Measure getSemiMajorAxisMeasure() {
        return new Measure(this.semiMajorAxis, this.unit);
    }

    private void setSemiMajorAxisMeasure(Measure measure) {
        if (this.semiMajorAxis == 0.0) {
            Unit<Length> unit = this.unit;
            this.semiMajorAxis = measure.value;
            ArgumentChecks.ensureStrictlyPositive((String)"semiMajorAxis", (double)this.semiMajorAxis);
            this.unit = measure.getUnit(Length.class);
            this.harmonizeAxisUnits(unit);
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultEllipsoid.class, (String)"setSemiMajorAxisMeasure", (String)"semiMajorAxis");
        }
    }

    @XmlElement(name="secondDefiningParameter", required=true)
    private SecondDefiningParameter getSecondDefiningParameter() {
        return new SecondDefiningParameter(this, true);
    }

    private void setSecondDefiningParameter(SecondDefiningParameter secondDefiningParameter) {
        boolean bl;
        Measure measure;
        if (secondDefiningParameter.secondDefiningParameter != null) {
            secondDefiningParameter = secondDefiningParameter.secondDefiningParameter;
        }
        boolean bl2 = false;
        if (Boolean.TRUE.equals(secondDefiningParameter.isSphere)) {
            boolean bl3 = bl2 = this.inverseFlattening != 0.0;
            if (!bl2) {
                this.inverseFlattening = Double.POSITIVE_INFINITY;
            }
        }
        if ((measure = secondDefiningParameter.measure) != null && !(bl2 |= ((bl = secondDefiningParameter.isIvfDefinitive()) ? this.inverseFlattening : this.semiMinorAxis) != 0.0)) {
            this.ivfDefinitive = bl;
            double d = measure.value;
            if (bl) {
                if (d == 0.0) {
                    d = Double.POSITIVE_INFINITY;
                }
                this.inverseFlattening = d;
                ArgumentChecks.ensureStrictlyPositive((String)"inverseFlattening", (double)this.inverseFlattening);
            } else {
                this.semiMinorAxis = d;
                ArgumentChecks.ensureStrictlyPositive((String)"semiMinorAxis", (double)this.semiMinorAxis);
                this.harmonizeAxisUnits((Unit<Length>)measure.getUnit(Length.class));
            }
        }
        if (bl2) {
            MetadataUtilities.propertyAlreadySet(DefaultEllipsoid.class, (String)"setSecondDefiningParameter", (String)"secondDefiningParameter");
        }
    }

    private void harmonizeAxisUnits(Unit<Length> unit) {
        if (this.unit == null) {
            this.unit = unit;
        } else if (unit != null && unit != this.unit) {
            this.semiMinorAxis = unit.getConverterTo(this.unit).convert(this.semiMinorAxis);
        }
    }
}

