/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultGeodeticDatum;
import org.apache.sis.referencing.datum.DefaultImageDatum;
import org.apache.sis.referencing.datum.DefaultParametricDatum;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.datum.SubTypes;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

@XmlType(name="AbstractDatumType", propOrder={"domainOfValidity", "scope", "anchorPoint", "realizationEpoch"})
@XmlRootElement(name="AbstractDatum")
@XmlSeeAlso(value={DefaultGeodeticDatum.class, DefaultVerticalDatum.class, DefaultTemporalDatum.class, DefaultParametricDatum.class, DefaultEngineeringDatum.class, DefaultImageDatum.class})
public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    private static final String ESRI_PREFIX = "D_";
    private InternationalString anchorDefinition;
    private long realizationEpoch;
    private Extent domainOfValidity;
    private InternationalString scope;

    public AbstractDatum(Map<String, ?> map) {
        super(map);
        this.realizationEpoch = MetadataUtilities.toMilliseconds((Date)((Date)Containers.property(map, (Object)"realizationEpoch", Date.class)));
        this.domainOfValidity = (Extent)Containers.property(map, (Object)"domainOfValidity", Extent.class);
        this.anchorDefinition = Types.toInternationalString(map, (String)"anchorPoint");
        this.scope = Types.toInternationalString(map, (String)"scope");
    }

    protected AbstractDatum(Datum datum) {
        super((IdentifiedObject)datum);
        this.realizationEpoch = MetadataUtilities.toMilliseconds((Date)datum.getRealizationEpoch());
        this.domainOfValidity = datum.getDomainOfValidity();
        this.scope = datum.getScope();
        this.anchorDefinition = datum.getAnchorPoint();
    }

    public static AbstractDatum castOrCopy(Datum datum) {
        return SubTypes.castOrCopy(datum);
    }

    public Class<? extends Datum> getInterface() {
        return Datum.class;
    }

    @XmlElement(name="anchorDefinition")
    public InternationalString getAnchorPoint() {
        return this.anchorDefinition;
    }

    @XmlSchemaType(name="date")
    @XmlElement(name="realizationEpoch")
    public Date getRealizationEpoch() {
        return MetadataUtilities.toDate((long)this.realizationEpoch);
    }

    @XmlElement(name="domainOfValidity")
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @XmlElement(name="scope", required=true)
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public boolean isHeuristicMatchForName(String string) {
        return NameToIdentifier.isHeuristicMatchForName((Identifier)super.getName(), super.getAlias(), (CharSequence)string, (NameToIdentifier.Simplifier)Simplifier.INSTANCE);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                AbstractDatum abstractDatum = (AbstractDatum)object;
                return this.realizationEpoch == abstractDatum.realizationEpoch && Objects.equals(this.domainOfValidity, abstractDatum.domainOfValidity) && Objects.equals(this.anchorDefinition, abstractDatum.anchorDefinition) && Objects.equals(this.scope, abstractDatum.scope);
            }
            case BY_CONTRACT: {
                Datum datum = (Datum)object;
                return Utilities.deepEquals((Object)this.getRealizationEpoch(), (Object)datum.getRealizationEpoch(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getDomainOfValidity(), (Object)datum.getDomainOfValidity(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getAnchorPoint(), (Object)datum.getAnchorPoint(), (ComparisonMode)comparisonMode) && Utilities.deepEquals((Object)this.getScope(), (Object)datum.getScope(), (ComparisonMode)comparisonMode);
            }
        }
        Datum datum = (Datum)object;
        Boolean bl = Citations.hasCommonIdentifier(this.getIdentifiers(), (Iterable)datum.getIdentifiers());
        if (bl != null) {
            return bl;
        }
        return this.isHeuristicMatchForName(datum.getName().getCode()) || IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)datum, this.getName().getCode());
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.anchorDefinition, this.realizationEpoch, this.domainOfValidity, this.scope);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Citation citation = formatter.getNameAuthority();
        String string = IdentifiedObjects.getName(this, citation);
        if (string == null) {
            string = IdentifiedObjects.getName(this, null);
            if (string == null) {
                return super.formatTo(formatter);
            }
            if ("ESRI".equalsIgnoreCase(org.apache.sis.metadata.iso.citation.Citations.getCodeSpace((Citation)citation)) && !string.startsWith(ESRI_PREFIX)) {
                string = ESRI_PREFIX + string;
            }
        }
        formatter.append(string, ElementKind.DATUM);
        return null;
    }

    AbstractDatum() {
        super((IdentifiedObject)NilReferencingObject.INSTANCE);
        this.realizationEpoch = Long.MIN_VALUE;
    }

    private void setAnchorPoint(InternationalString internationalString) {
        if (this.anchorDefinition == null) {
            this.anchorDefinition = internationalString;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDatum.class, (String)"setAnchorPoint", (String)"anchorDefinition");
        }
    }

    private void setRealizationEpoch(Date date) {
        if (this.realizationEpoch == Long.MIN_VALUE) {
            this.realizationEpoch = date.getTime();
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDatum.class, (String)"setRealizationEpoch", (String)"realizationEpoch");
        }
    }

    private void setDomainOfValidity(Extent extent) {
        if (this.domainOfValidity == null) {
            this.domainOfValidity = extent;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDatum.class, (String)"setDomainOfValidity", (String)"domainOfValidity");
        }
    }

    private void setScope(InternationalString internationalString) {
        if (this.scope == null) {
            this.scope = internationalString;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractDatum.class, (String)"setScope", (String)"scope");
        }
    }

    static class Simplifier
    extends NameToIdentifier.Simplifier {
        static final Simplifier INSTANCE = new Simplifier();

        Simplifier() {
        }

        protected CharSequence apply(CharSequence charSequence) {
            if (CharSequences.startsWith((CharSequence)(charSequence = super.apply(charSequence)), (CharSequence)AbstractDatum.ESRI_PREFIX, (boolean)false)) {
                charSequence = charSequence.subSequence(AbstractDatum.ESRI_PREFIX.length(), charSequence.length());
            }
            return charSequence;
        }
    }
}

