/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.referencing.Legacy;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

@XmlType(name="GeodeticCRSType", propOrder={"ellipsoidalCS", "cartesianCS", "sphericalCS", "datum"})
@XmlRootElement(name="GeodeticCRS")
class DefaultGeodeticCRS
extends AbstractCRS
implements GeodeticCRS {
    private static final long serialVersionUID = -6205678223972395910L;
    private GeodeticDatum datum;

    DefaultGeodeticCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, CoordinateSystem coordinateSystem) {
        super(map, coordinateSystem);
        ArgumentChecks.ensureNonNull((String)"datum", (Object)geodeticDatum);
        this.datum = geodeticDatum;
    }

    protected DefaultGeodeticCRS(GeodeticCRS geodeticCRS) {
        super((CoordinateReferenceSystem)geodeticCRS);
        this.datum = geodeticCRS.getDatum();
    }

    public Class<? extends GeodeticCRS> getInterface() {
        return GeodeticCRS.class;
    }

    @XmlElement(name="geodeticDatum", required=true)
    public GeodeticDatum getDatum() {
        return this.datum;
    }

    @Override
    AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultGeodeticCRS(map, this.datum, coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean bl;
        VerticalCRS verticalCRS;
        GeodeticDatum geodeticDatum;
        boolean bl2;
        WKTUtilities.appendName(this, formatter, null);
        CoordinateSystem coordinateSystem = this.getCoordinateSystem();
        Convention convention = formatter.getConvention();
        boolean bl3 = convention.majorVersion() == 1;
        boolean bl4 = bl2 = bl3 && coordinateSystem instanceof EllipsoidalCS;
        if (bl2 && coordinateSystem.getDimension() == 3) {
            geodeticDatum = CRS.getHorizontalComponent(this);
            verticalCRS = CRS.getVerticalComponent(this, true);
            if (geodeticDatum != null && verticalCRS != null) {
                if (AxisDirection.UP.equals((Object)AxisDirections.absolute((AxisDirection)coordinateSystem.getAxis(0).getDirection()))) {
                    GeodeticDatum geodeticDatum2 = geodeticDatum;
                    geodeticDatum = verticalCRS;
                    verticalCRS = geodeticDatum2;
                }
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable((CoordinateReferenceSystem)geodeticDatum));
                formatter.newLine();
                formatter.append(WKTUtilities.toFormattable((CoordinateReferenceSystem)verticalCRS));
                formatter.newLine();
                return "Compd_CS";
            }
        }
        geodeticDatum = this.getDatum();
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(geodeticDatum));
        formatter.newLine();
        verticalCRS = geodeticDatum.getPrimeMeridian();
        Unit unit = AxisDirections.getAngularUnit((CoordinateSystem)coordinateSystem, null);
        if (convention != Convention.WKT2_SIMPLIFIED || ReferencingUtilities.getGreenwichLongitude((PrimeMeridian)verticalCRS, (Unit<Angle>)Units.DEGREE) != 0.0) {
            Unit unit2 = formatter.addContextualUnit(unit);
            formatter.indent(1);
            formatter.append(WKTUtilities.toFormattable((PrimeMeridian)verticalCRS));
            formatter.indent(-1);
            formatter.newLine();
            formatter.restoreContextualUnit(unit, unit2);
        }
        if (bl3) {
            if (!bl2) {
                if (coordinateSystem instanceof CartesianCS) {
                    coordinateSystem = Legacy.forGeocentricCRS((CartesianCS)coordinateSystem, true);
                } else {
                    formatter.setInvalidWKT((IdentifiedObject)coordinateSystem, null);
                }
            }
            bl = false;
        } else {
            bl = DefaultGeodeticCRS.isBaseCRS(formatter);
        }
        if (!bl || convention == Convention.INTERNAL) {
            this.formatCS(formatter, coordinateSystem, ReferencingUtilities.getUnit(coordinateSystem), bl3);
        } else if (convention.isSimplified()) {
            formatter.append(formatter.toContextualUnit(unit));
        }
        if (bl3) {
            return bl2 ? "GeogCS" : "GeocCS";
        }
        return bl ? "BaseGeodCRS" : formatter.shortOrLong("GeodCRS", "GeodeticCRS");
    }

    DefaultGeodeticCRS() {
    }

    private void setDatum(GeodeticDatum geodeticDatum) {
        if (this.datum == null) {
            this.datum = geodeticDatum;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultGeodeticCRS.class, (String)"setDatum", (String)"geodeticDatum");
        }
    }

    @XmlElement(name="ellipsoidalCS")
    private EllipsoidalCS getEllipsoidalCS() {
        return this.getCoordinateSystem(EllipsoidalCS.class);
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="sphericalCS")
    private SphericalCS getSphericalCS() {
        return this.getCoordinateSystem(SphericalCS.class);
    }

    private void setEllipsoidalCS(EllipsoidalCS ellipsoidalCS) {
        super.setCoordinateSystem("ellipsoidalCS", (CoordinateSystem)ellipsoidalCS);
    }

    private void setCartesianCS(CartesianCS cartesianCS) {
        super.setCoordinateSystem("cartesianCS", (CoordinateSystem)cartesianCS);
    }

    private void setSphericalCS(SphericalCS sphericalCS) {
        super.setCoordinateSystem("sphericalCS", (CoordinateSystem)sphericalCS);
    }
}

