/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class NameIterator
implements Iterator<ReferenceIdentifier> {
    private ReferenceIdentifier next;
    private final Iterator<GenericName> alias;

    NameIterator(IdentifiedObject identifiedObject) {
        this.alias = identifiedObject.getAlias().iterator();
        this.next = identifiedObject.getName();
        if (NameIterator.isUnnamed(this.next)) {
            this.next();
        }
    }

    static boolean isUnnamed(ReferenceIdentifier referenceIdentifier) {
        return referenceIdentifier == null || referenceIdentifier == NilReferencingObject.UNNAMED;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ReferenceIdentifier next() {
        ReferenceIdentifier referenceIdentifier = this.next;
        while (this.alias.hasNext()) {
            GenericName genericName = this.alias.next();
            if (!(genericName instanceof ReferenceIdentifier)) continue;
            this.next = (ReferenceIdentifier)genericName;
            return referenceIdentifier;
        }
        this.next = null;
        return referenceIdentifier;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static int count(IdentifiedObject identifiedObject) {
        int n = 0;
        NameIterator nameIterator = new NameIterator(identifiedObject);
        while (nameIterator.hasNext()) {
            nameIterator.next();
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    static String getID(Context context, IdentifiedObject identifiedObject, ReferenceIdentifier referenceIdentifier, Collection<? extends GenericName> collection, Collection<? extends ReferenceIdentifier> collection2) {
        String string = Context.getObjectID((Context)context, (Object)identifiedObject);
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (collection2 != null) {
                for (ReferenceIdentifier referenceIdentifier2 : collection2) {
                    if (Utilities.appendUnicodeIdentifier((StringBuilder)stringBuilder, (char)'-', (String)referenceIdentifier2.getCodeSpace(), (String)"", (boolean)true) | Utilities.appendUnicodeIdentifier((StringBuilder)stringBuilder, (char)'-', (String)NameMeaning.toObjectType(identifiedObject.getClass()), (String)"", (boolean)false) | Utilities.appendUnicodeIdentifier((StringBuilder)stringBuilder, (char)'-', (String)referenceIdentifier2.getCode(), (String)"", (boolean)true) && Context.setObjectForID((Context)context, (Object)identifiedObject, (String)(string = stringBuilder.toString()))) {
                        return string;
                    }
                    stringBuilder.setLength(0);
                }
            }
            if ((NameIterator.isUnnamed(referenceIdentifier) || !Utilities.appendUnicodeIdentifier((StringBuilder)stringBuilder, (char)'-', (String)referenceIdentifier.getCode(), (String)"", (boolean)false)) && collection != null) {
                GenericName genericName;
                Iterator<? extends ReferenceIdentifier> iterator = collection.iterator();
                while (iterator.hasNext() && !Utilities.appendUnicodeIdentifier((StringBuilder)stringBuilder, (char)'-', (String)(genericName = (GenericName)iterator.next()).toString(), (String)"", (boolean)false)) {
                }
            }
            if (stringBuilder.length() != 0 && !Context.setObjectForID((Context)context, (Object)identifiedObject, (String)(string = stringBuilder.toString()))) {
                int n = stringBuilder.append('-').length();
                boolean bl = false;
                do {
                    void var8_13;
                    if (++var8_13 == 100) {
                        return null;
                    }
                    string = stringBuilder.append((int)var8_13).toString();
                    stringBuilder.setLength(n);
                } while (!Context.setObjectForID((Context)context, (Object)identifiedObject, (String)string));
            }
        }
        return string;
    }
}

