/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.distance;

import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.apache.sis.distance.DistanceUtils;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.measure.Longitude;
import org.opengis.geometry.DirectPosition;

public class LatLonPointRadius {
    private final DirectPosition center;
    private final double radius;

    public LatLonPointRadius(DirectPosition directPosition, double d) {
        this.center = directPosition;
        this.radius = d;
    }

    public DirectPosition2D[] getCircularRegionApproximation(int n) {
        if (this.radius >= 20037.58) {
            DirectPosition2D[] directPosition2DArray;
            directPosition2DArray = new DirectPosition2D[]{new DirectPosition2D(-180.0, -90.0), new DirectPosition2D(-180.0, 90.0), new DirectPosition2D(180.0, 90.0), new DirectPosition2D(180.0, -90.0), directPosition2DArray[0]};
            return directPosition2DArray;
        }
        DirectPosition2D[] directPosition2DArray = new DirectPosition2D[n + 1];
        double d = 0.0;
        if (n > 0) {
            d = 360 / n;
        }
        for (int i = 0; i < n; ++i) {
            directPosition2DArray[i] = DistanceUtils.getPointOnGreatCircle(this.center.getOrdinate(1), this.center.getOrdinate(0), this.radius, (double)i * d);
        }
        directPosition2DArray[n] = directPosition2DArray[0];
        return directPosition2DArray;
    }

    public Rectangle2D getRectangularRegionApproximation(int n) {
        Cloneable cloneable;
        if (this.radius >= 20037.58) {
            return new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0);
        }
        int n2 = 0;
        Path2D.Double double_ = new Path2D.Double();
        DirectPosition2D directPosition2D = DistanceUtils.getPointOnGreatCircle(this.center.getOrdinate(1), this.center.getOrdinate(0), this.radius, 0.0);
        ((Path2D)double_).moveTo(directPosition2D.x + 180.0, directPosition2D.y + 90.0);
        DirectPosition2D directPosition2D2 = directPosition2D;
        for (int i = 1; i < 360; ++i) {
            cloneable = DistanceUtils.getPointOnGreatCircle(this.center.getOrdinate(1), this.center.getOrdinate(0), this.radius, i);
            ((Path2D)double_).lineTo(((DirectPosition2D)cloneable).x + 180.0, ((DirectPosition2D)cloneable).y + 90.0);
            if (LatLonPointRadius.dateLineCrossOver(Longitude.normalize((double)directPosition2D2.x), Longitude.normalize((double)((DirectPosition2D)cloneable).x))) {
                ++n2;
            }
            directPosition2D2 = cloneable;
        }
        if (LatLonPointRadius.dateLineCrossOver(Longitude.normalize((double)directPosition2D.x), Longitude.normalize((double)directPosition2D2.x))) {
            ++n2;
        }
        if (n2 == 1) {
            Rectangle2D rectangle2D = double_.getBounds2D();
            cloneable = new Rectangle2D.Double(0.0, 0.0, 360.0, rectangle2D.getMaxY());
            if (((Rectangle2D)cloneable).contains(this.center.getOrdinate(0) + 180.0, this.center.getOrdinate(1) + 90.0)) {
                return cloneable;
            }
            return new Rectangle2D.Double(0.0, rectangle2D.getMinY(), 360.0, 180.0 - rectangle2D.getMinY());
        }
        if (double_.contains(this.center.getOrdinate(0) + 180.0, this.center.getOrdinate(1) + 90.0)) {
            Rectangle2D rectangle2D = double_.getBounds2D();
            if (rectangle2D.getMaxX() - rectangle2D.getMinX() > 359.0) {
                return new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0);
            }
            if (rectangle2D.getMinX() < 0.0 || rectangle2D.getMaxX() > 360.0) {
                return new Rectangle2D.Double(0.0, rectangle2D.getY(), 360.0, rectangle2D.getHeight());
            }
            return double_.getBounds2D();
        }
        Area area = new Area(double_);
        cloneable = new Area(new Rectangle2D.Double(0.0, 0.0, 360.0, 180.0));
        ((Area)cloneable).subtract(area);
        return ((Area)cloneable).getBounds2D();
    }

    private static boolean dateLineCrossOver(double d, double d2) {
        return Math.abs(d - d2) > 180.0;
    }
}

