/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.sql.LookupInfo;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;

final class Dispatcher
implements InvocationHandler {
    final String identifier;
    private final MetadataSource source;
    byte preferredIndex;
    private volatile transient Object cache;
    private transient long nullValues;

    public Dispatcher(String string, MetadataSource metadataSource) {
        this.identifier = string;
        this.source = metadataSource;
        this.preferredIndex = (byte)-1;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        int n = objectArray != null ? objectArray.length : 0;
        switch (method.getName()) {
            case "toString": {
                if (n != 0) break;
                return this.toString(method.getDeclaringClass());
            }
            case "hashCode": {
                if (n != 0) break;
                return System.identityHashCode(object);
            }
            case "equals": {
                if (n != 1) break;
                return object == objectArray[0];
            }
            case "identifier": {
                if (n != 1) break;
                return objectArray[0] == this.source ? this.identifier : null;
            }
            default: {
                Class<?> clazz;
                Object object2;
                if (n != 0) break;
                try {
                    object2 = this.fetchValue(this.source.getLookupInfo(method.getDeclaringClass()), method);
                }
                catch (ReflectiveOperationException | SQLException | MetadataStoreException exception) {
                    throw new BackingStoreException(this.error(method), (Throwable)exception);
                }
                if (object2 == null && Collection.class.isAssignableFrom(clazz = method.getReturnType())) {
                    object2 = CollectionsExt.empty(clazz);
                }
                return object2;
            }
        }
        throw new BackingStoreException(Errors.format((short)162, (Object)(Classes.getShortName(method.getDeclaringClass()) + '.' + method.getName())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchValue(LookupInfo lookupInfo, Method method) throws ReflectiveOperationException, SQLException, MetadataStoreException {
        long l;
        Object object;
        block22: {
            object = null;
            l = 1L << lookupInfo.asIndexMap(this.source.standard).get(method.getName());
            if ((this.nullValues & l) == 0L) {
                Class<?> clazz = lookupInfo.getMetadataType();
                boolean bl = Semaphores.queryAndSet((int)1);
                try {
                    Dependencies dependencies;
                    Class<?> clazz2;
                    Object object2 = this.cache;
                    if (object2 != null) {
                        clazz2 = object2;
                        synchronized (clazz2) {
                            object = method.invoke(object2, new Object[0]);
                        }
                    }
                    if (object != null) break block22;
                    lookupInfo.setMetadataType(clazz);
                    object = this.source.readColumn(lookupInfo, method, this);
                    if (object != null) {
                        if (object2 == null) {
                            clazz2 = this.source.standard.getImplementation(clazz);
                            if (clazz2 == null) {
                                Object object3 = object;
                                return object3;
                            }
                            this.cache = object2 = clazz2.newInstance();
                        }
                        clazz2 = this.source.standard.asValueMap(object2, clazz, KeyNamePolicy.METHOD_NAME, ValueExistencePolicy.ALL);
                        Class<?> clazz3 = object2;
                        synchronized (clazz3) {
                            object = JDK8.putIfAbsent((Map)((Object)clazz2), (Object)method.getName(), (Object)object);
                            if (object == null) {
                                object = method.invoke(object2, new Object[0]);
                            }
                            break block22;
                        }
                    }
                    clazz2 = this.source.standard.getImplementation(clazz);
                    if (clazz2 == null || (dependencies = clazz2.getMethod(method.getName(), new Class[0]).getAnnotation(Dependencies.class)) == null) break block22;
                    boolean bl2 = false;
                    for (String string : dependencies.value()) {
                        lookupInfo.setMetadataType(clazz);
                        bl2 |= this.fetchValue(lookupInfo, clazz2.getMethod(string, new Class[0])) != null;
                    }
                    if (!bl2 || (object2 = this.cache) == null) break block22;
                    Object object3 = object2;
                    synchronized (object3) {
                        object = method.invoke(object2, new Object[0]);
                    }
                }
                finally {
                    if (!bl) {
                        Semaphores.clear((int)1);
                    }
                }
            }
        }
        if (object == null) {
            this.nullValues |= l;
        }
        return object;
    }

    final String error(Method method) {
        Class clazz;
        Class clazz2 = method.getReturnType();
        if (Collection.class.isAssignableFrom(clazz2) && (clazz = Classes.boundOfParameterizedProperty((Method)method)) != null) {
            clazz2 = clazz;
        }
        return Errors.format((short)21, clazz2, (Object)this.identifier);
    }

    private String toString(Class<?> clazz) {
        return Classes.getShortName(clazz) + "[id=\u201c" + this.identifier + "\u201d]";
    }

    public String toString() {
        return this.toString(this.getClass());
    }
}

