/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.extent;

import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.PrimitiveTypeProperties;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.InvalidMetadataException;
import org.apache.sis.metadata.iso.extent.AbstractGeographicExtent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.operation.TransformException;

@XmlType(name="EX_GeographicBoundingBox_Type", propOrder={"westBoundLongitude", "eastBoundLongitude", "southBoundLatitude", "northBoundLatitude"})
@XmlRootElement(name="EX_GeographicBoundingBox")
public class DefaultGeographicBoundingBox
extends AbstractGeographicExtent
implements GeographicBoundingBox {
    private static final long serialVersionUID = -9200149606040429957L;
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;

    public DefaultGeographicBoundingBox() {
        this.westBoundLongitude = Double.NaN;
        this.eastBoundLongitude = Double.NaN;
        this.southBoundLatitude = Double.NaN;
        this.northBoundLatitude = Double.NaN;
    }

    public DefaultGeographicBoundingBox(double d, double d2, double d3, double d4) throws IllegalArgumentException {
        super(true);
        DefaultGeographicBoundingBox.verifyBounds(d3, d4);
        this.westBoundLongitude = d;
        this.eastBoundLongitude = d2;
        this.southBoundLatitude = d3;
        this.northBoundLatitude = d4;
        this.normalize();
    }

    public DefaultGeographicBoundingBox(GeographicBoundingBox geographicBoundingBox) {
        super((GeographicExtent)geographicBoundingBox);
        if (geographicBoundingBox != null) {
            this.westBoundLongitude = geographicBoundingBox.getWestBoundLongitude();
            this.eastBoundLongitude = geographicBoundingBox.getEastBoundLongitude();
            this.southBoundLatitude = geographicBoundingBox.getSouthBoundLatitude();
            this.northBoundLatitude = geographicBoundingBox.getNorthBoundLatitude();
            DefaultGeographicBoundingBox.verifyBounds(this.southBoundLatitude, this.northBoundLatitude);
            this.normalize();
        } else {
            this.westBoundLongitude = Double.NaN;
            this.eastBoundLongitude = Double.NaN;
            this.southBoundLatitude = Double.NaN;
            this.northBoundLatitude = Double.NaN;
        }
    }

    public static DefaultGeographicBoundingBox castOrCopy(GeographicBoundingBox geographicBoundingBox) {
        if (geographicBoundingBox == null || geographicBoundingBox instanceof DefaultGeographicBoundingBox) {
            return (DefaultGeographicBoundingBox)geographicBoundingBox;
        }
        return new DefaultGeographicBoundingBox(geographicBoundingBox);
    }

    static boolean getInclusion(Boolean bl) throws InvalidMetadataException {
        if (bl == null) {
            return true;
        }
        boolean bl2 = bl;
        if (bl2 || bl == Boolean.FALSE || !(PrimitiveTypeProperties.property((Object)bl) instanceof NilReason)) {
            return bl2;
        }
        throw new InvalidMetadataException(Errors.format((short)89, (Object)"inclusion"));
    }

    @ValueRange(minimum=-180.0, maximum=180.0)
    @XmlElement(name="westBoundLongitude", required=true)
    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public void setWestBoundLongitude(double d) {
        this.checkWritePermission();
        if (d != 180.0) {
            d = Longitude.normalize((double)d);
        }
        this.westBoundLongitude = d;
    }

    @ValueRange(minimum=-180.0, maximum=180.0)
    @XmlElement(name="eastBoundLongitude", required=true)
    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public void setEastBoundLongitude(double d) {
        this.checkWritePermission();
        if (d != 180.0) {
            d = Longitude.normalize((double)d);
        }
        this.eastBoundLongitude = d;
    }

    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="southBoundLatitude", required=true)
    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public void setSouthBoundLatitude(double d) {
        this.checkWritePermission();
        this.southBoundLatitude = Latitude.clamp((double)d);
        if (this.southBoundLatitude > this.northBoundLatitude) {
            this.northBoundLatitude = Double.NaN;
        }
    }

    @ValueRange(minimum=-90.0, maximum=90.0)
    @XmlElement(name="northBoundLatitude", required=true)
    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }

    public void setNorthBoundLatitude(double d) {
        this.checkWritePermission();
        this.northBoundLatitude = Latitude.clamp((double)d);
        if (this.northBoundLatitude < this.southBoundLatitude) {
            this.southBoundLatitude = Double.NaN;
        }
    }

    private static void verifyBounds(double d, double d2) throws IllegalArgumentException {
        if (d > d2) {
            throw new IllegalArgumentException(Errors.format((short)57, (Object)new Latitude(d), (Object)new Latitude(d2), (Object)Vocabulary.format((short)57)));
        }
    }

    private void normalize() {
        this.southBoundLatitude = Latitude.clamp((double)this.southBoundLatitude);
        this.northBoundLatitude = Latitude.clamp((double)this.northBoundLatitude);
        double d = this.eastBoundLongitude - this.westBoundLongitude;
        if (!(d >= 360.0)) {
            this.westBoundLongitude = Longitude.normalize((double)this.westBoundLongitude);
            this.eastBoundLongitude = Longitude.normalize((double)this.eastBoundLongitude);
            if (d != 0.0) {
                if (this.eastBoundLongitude == -180.0) {
                    this.eastBoundLongitude = 180.0;
                }
                return;
            }
            if (!MathFunctions.isPositiveZero((double)this.westBoundLongitude) || !MathFunctions.isNegativeZero((double)this.eastBoundLongitude)) {
                return;
            }
        }
        this.westBoundLongitude = -180.0;
        this.eastBoundLongitude = 180.0;
    }

    public void setBounds(double d, double d2, double d3, double d4) throws IllegalArgumentException {
        this.checkWritePermission();
        DefaultGeographicBoundingBox.verifyBounds(d3, d4);
        this.westBoundLongitude = d;
        this.eastBoundLongitude = d2;
        this.southBoundLatitude = d3;
        this.northBoundLatitude = d4;
        this.normalize();
    }

    public void setBounds(Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        this.checkWritePermission();
        ReferencingServices.getInstance().setBounds(envelope, this);
        this.setInclusion(Boolean.TRUE);
    }

    public void setBounds(GeographicBoundingBox geographicBoundingBox) {
        ArgumentChecks.ensureNonNull((String)"box", (Object)geographicBoundingBox);
        this.setBounds(geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getNorthBoundLatitude());
        this.setInclusion(geographicBoundingBox.getInclusion());
    }

    private int denormalize(double d, double d2) {
        boolean bl;
        if (d > d2 == (bl = this.westBoundLongitude > this.eastBoundLongitude)) {
            return bl ? 3 : 0;
        }
        double d3 = this.westBoundLongitude - d;
        double d4 = d2 - this.eastBoundLongitude;
        if (!bl) {
            if (d3 >= 0.0) {
                return 1;
            }
            if (d4 >= 0.0) {
                return -1;
            }
            return d3 < d4 ? -1 : 1;
        }
        if (!(d3 <= 0.0) && d4 <= 0.0 || d3 > d4) {
            this.westBoundLongitude -= 360.0;
            return -2;
        }
        this.eastBoundLongitude += 360.0;
        return 2;
    }

    public void add(GeographicBoundingBox geographicBoundingBox) {
        this.checkWritePermission();
        ArgumentChecks.ensureNonNull((String)"box", (Object)geographicBoundingBox);
        double d = geographicBoundingBox.getWestBoundLongitude();
        double d2 = geographicBoundingBox.getEastBoundLongitude();
        double d3 = geographicBoundingBox.getSouthBoundLatitude();
        double d4 = geographicBoundingBox.getNorthBoundLatitude();
        boolean bl = DefaultGeographicBoundingBox.getInclusion(this.getInclusion());
        boolean bl2 = DefaultGeographicBoundingBox.getInclusion(geographicBoundingBox.getInclusion());
        int n = this.denormalize(d, d2);
        switch (n) {
            case -1: {
                d -= 360.0;
                break;
            }
            case 1: {
                d2 += 360.0;
            }
        }
        if (bl == bl2) {
            this.westBoundLongitude = Math.min(this.westBoundLongitude, d);
            this.eastBoundLongitude = Math.max(this.eastBoundLongitude, d2);
            this.southBoundLatitude = Math.min(this.southBoundLatitude, d3);
            this.northBoundLatitude = Math.max(this.northBoundLatitude, d4);
        } else {
            if (d3 <= this.southBoundLatitude && d4 >= this.northBoundLatitude) {
                this.westBoundLongitude = Math.max(this.westBoundLongitude, d);
                this.eastBoundLongitude = Math.min(this.eastBoundLongitude, d2);
            }
            if (d <= this.westBoundLongitude && d2 >= this.eastBoundLongitude) {
                this.southBoundLatitude = Math.max(this.southBoundLatitude, d3);
                this.northBoundLatitude = Math.min(this.northBoundLatitude, d4);
            }
        }
        if (n == 3 && this.eastBoundLongitude > this.westBoundLongitude) {
            this.westBoundLongitude = -180.0;
            this.eastBoundLongitude = 180.0;
        }
        this.normalize();
    }

    public void intersect(GeographicBoundingBox geographicBoundingBox) throws IllegalArgumentException {
        this.checkWritePermission();
        ArgumentChecks.ensureNonNull((String)"box", (Object)geographicBoundingBox);
        if (DefaultGeographicBoundingBox.getInclusion(this.getInclusion()) != DefaultGeographicBoundingBox.getInclusion(geographicBoundingBox.getInclusion())) {
            throw new IllegalArgumentException(Errors.format((short)63, (Object)"inclusion"));
        }
        double d = geographicBoundingBox.getWestBoundLongitude();
        double d2 = geographicBoundingBox.getEastBoundLongitude();
        double d3 = geographicBoundingBox.getSouthBoundLatitude();
        double d4 = geographicBoundingBox.getNorthBoundLatitude();
        int n = this.denormalize(d, d2);
        switch (n) {
            case -1: {
                d -= 360.0;
                break;
            }
            case 1: {
                d2 += 360.0;
            }
        }
        this.westBoundLongitude = Math.max(this.westBoundLongitude, d);
        this.eastBoundLongitude = Math.min(this.eastBoundLongitude, d2);
        this.southBoundLatitude = Math.max(this.southBoundLatitude, d3);
        this.northBoundLatitude = Math.min(this.northBoundLatitude, d4);
        if (n != 3 && this.westBoundLongitude > this.eastBoundLongitude) {
            this.eastBoundLongitude = Double.NaN;
            this.westBoundLongitude = Double.NaN;
        }
        if (this.southBoundLatitude > this.northBoundLatitude) {
            this.northBoundLatitude = Double.NaN;
            this.southBoundLatitude = Double.NaN;
        }
        this.normalize();
    }

    @Override
    public boolean isEmpty() {
        return Double.isNaN(this.eastBoundLongitude) && Double.isNaN(this.westBoundLongitude) && Double.isNaN(this.northBoundLatitude) && Double.isNaN(this.southBoundLatitude);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == DefaultGeographicBoundingBox.class) {
            DefaultGeographicBoundingBox defaultGeographicBoundingBox = (DefaultGeographicBoundingBox)object;
            return Objects.equals(this.getInclusion(), defaultGeographicBoundingBox.getInclusion()) && Double.doubleToLongBits(this.southBoundLatitude) == Double.doubleToLongBits(defaultGeographicBoundingBox.southBoundLatitude) && Double.doubleToLongBits(this.northBoundLatitude) == Double.doubleToLongBits(defaultGeographicBoundingBox.northBoundLatitude) && Double.doubleToLongBits(this.eastBoundLongitude) == Double.doubleToLongBits(defaultGeographicBoundingBox.eastBoundLongitude) && Double.doubleToLongBits(this.westBoundLongitude) == Double.doubleToLongBits(defaultGeographicBoundingBox.westBoundLongitude);
        }
        return super.equals(object, comparisonMode);
    }
}

