/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Date;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.NilReason;

public final class MetadataUtilities
extends Static {
    private MetadataUtilities() {
    }

    public static long toMilliseconds(Date date) {
        return date != null ? date.getTime() : Long.MIN_VALUE;
    }

    public static Date toDate(long l) {
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public static boolean ensurePositive(Class<?> clazz, String string, boolean bl, Number number) throws IllegalArgumentException {
        if (number != null) {
            double d = number.doubleValue();
            if (!(!bl ? d >= 0.0 : d > 0.0) && NilReason.forObject((Object)number) == null) {
                String string2 = MetadataUtilities.logOrFormat(clazz, string, bl ? (short)165 : 92, string, number);
                if (string2 != null) {
                    throw new IllegalArgumentException(string2);
                }
                return false;
            }
        }
        return true;
    }

    public static boolean ensureInRange(Class<?> clazz, String string, Number number, Number number2, Number number3) throws IllegalArgumentException {
        double d;
        if (!(number3 == null || (d = number3.doubleValue()) >= number.doubleValue() && d <= number2.doubleValue() || NilReason.forObject((Object)number3) != null)) {
            String string2 = MetadataUtilities.logOrFormat(clazz, string, (short)166, string, number, number2, number3);
            if (string2 != null) {
                throw new IllegalArgumentException(string2);
            }
            return false;
        }
        return true;
    }

    private static String logOrFormat(Class<?> clazz, String string, short s, Object ... objectArray) {
        Context context = Context.current();
        if (context == null) {
            return Errors.format((short)s, (Object)objectArray);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 3).append("set").append(string);
        stringBuilder.setCharAt(3, Character.toUpperCase(stringBuilder.charAt(3)));
        Context.warningOccured((Context)context, clazz, (String)stringBuilder.toString(), Errors.class, (short)s, (Object[])objectArray);
        return null;
    }

    public static void propertyAlreadySet(Class<?> clazz, String string, String string2) throws IllegalStateException {
        Context context = Context.current();
        if (context == null) {
            throw new IllegalStateException(Errors.format((short)27, (Object)string2));
        }
        Context.warningOccured((Context)context, clazz, (String)string, Errors.class, (short)27, (Object[])new Object[]{string2});
    }

    public static String getObjectID(IdentifiedObject identifiedObject) {
        Context context = Context.current();
        String string = Context.getObjectID((Context)context, (Object)identifiedObject);
        if (string == null && (string = (String)identifiedObject.getIdentifierMap().getSpecialized(IdentifierSpace.ID)) != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!Utilities.appendUnicodeIdentifier((StringBuilder)stringBuilder, (char)'\u0000', (String)string, (String)":-", (boolean)false)) {
                return null;
            }
            string = stringBuilder.toString();
            if (!Context.setObjectForID((Context)context, (Object)identifiedObject, (String)string)) {
                int n = stringBuilder.append('-').length();
                int n2 = 0;
                do {
                    if (++n2 == 100) {
                        return null;
                    }
                    string = stringBuilder.append(n2).toString();
                    stringBuilder.setLength(n);
                } while (!Context.setObjectForID((Context)context, (Object)identifiedObject, (String)string));
            }
        }
        return string;
    }

    public static void setObjectID(IdentifiedObject identifiedObject, String string) {
        if ((string = CharSequences.trimWhitespaces((String)string)) != null && !string.isEmpty()) {
            identifiedObject.getIdentifierMap().putSpecialized(IdentifierSpace.ID, (Object)string);
            Context context = Context.current();
            if (!Context.setObjectForID((Context)context, (Object)identifiedObject, (String)string)) {
                Context.warningOccured((Context)context, identifiedObject.getClass(), (String)"setID", Errors.class, (short)25, (Object[])new Object[]{string});
            }
        }
    }
}

