/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.InvalidFeatureException;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.Static;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.quality.Element;
import org.opengis.metadata.quality.Result;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public final class Features
extends Static {
    private Features() {
    }

    public static <V> DefaultAttributeType<V> cast(DefaultAttributeType<?> defaultAttributeType, Class<V> clazz) throws ClassCastException {
        Class<?> clazz2;
        if (defaultAttributeType != null && !clazz.equals(clazz2 = defaultAttributeType.getValueClass())) {
            throw new ClassCastException(Resources.format((short)13, defaultAttributeType.getName(), clazz, clazz2));
        }
        return defaultAttributeType;
    }

    public static <V> AbstractAttribute<V> cast(AbstractAttribute<?> abstractAttribute, Class<V> clazz) throws ClassCastException {
        Class<?> clazz2;
        if (abstractAttribute != null && !clazz.equals(clazz2 = abstractAttribute.getType().getValueClass())) {
            throw new ClassCastException(Resources.format((short)13, abstractAttribute.getName(), clazz, clazz2));
        }
        return abstractAttribute;
    }

    public static GenericName getValueTypeName(AbstractIdentifiedType abstractIdentifiedType) {
        AbstractIdentifiedType abstractIdentifiedType2;
        if (abstractIdentifiedType instanceof DefaultAssociationRole) {
            return DefaultAssociationRole.getValueTypeName((DefaultAssociationRole)abstractIdentifiedType);
        }
        if (abstractIdentifiedType instanceof DefaultAttributeType) {
            DefaultNameFactory defaultNameFactory = (DefaultNameFactory)DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
            return defaultNameFactory.toTypeName(((DefaultAttributeType)abstractIdentifiedType).getValueClass());
        }
        if (abstractIdentifiedType instanceof AbstractOperation && (abstractIdentifiedType2 = ((AbstractOperation)abstractIdentifiedType).getResult()) != null) {
            return abstractIdentifiedType2.getName();
        }
        return null;
    }

    public static void validate(AbstractFeature abstractFeature) throws IllegalArgumentException {
        if (abstractFeature != null) {
            DataQuality dataQuality = abstractFeature.quality();
            for (Element element : dataQuality.getReports()) {
                for (Result result : element.getResults()) {
                    InternationalString internationalString;
                    if (!(result instanceof ConformanceResult) || !Boolean.FALSE.equals(((ConformanceResult)result).pass()) || (internationalString = ((ConformanceResult)result).getExplanation()) == null) continue;
                    throw new InvalidFeatureException(internationalString);
                }
            }
        }
    }
}

