/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.web.registration;

import java.util.EnumSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.util.Environment;
import org.apache.sirona.web.discovery.GaugeDiscoveryListener;
import org.apache.sirona.web.lifecycle.LazyJspMonitoringFilterActivator;
import org.apache.sirona.web.lifecycle.SironaLifecycle;
import org.apache.sirona.web.servlet.SironaFilter;
import org.apache.sirona.web.session.SironaSessionListener;

public class WebSironaInitializer
implements ServletContainerInitializer {
    private static final String JSP_ACTIVATED = "org.apache.sirona.web.jsp.activated";
    private static final String ACTIVATED = "org.apache.sirona.web.activated";

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        String activated;
        if (Environment.isCollector()) {
            return;
        }
        String falseStr = Boolean.FALSE.toString();
        if (falseStr.equalsIgnoreCase(Configuration.getProperty((String)ACTIVATED, (String)(activated = ctx.getInitParameter(ACTIVATED))))) {
            return;
        }
        String monStatus = Boolean.toString(!falseStr.equalsIgnoreCase(ctx.getInitParameter("org.apache.sirona.web.monitored-status")));
        ctx.setAttribute("org.apache.sirona.web.monitored-status", (Object)monStatus);
        ctx.addListener(SironaSessionListener.class);
        ctx.addListener(GaugeDiscoveryListener.class);
        if (ctx.getClassLoader().equals(Repository.class.getClassLoader())) {
            ctx.addListener(SironaLifecycle.class);
        }
        String ignoredUrls = ctx.getInitParameter("org.apache.sirona.web.ignored-urls");
        String monitoredUrls = ctx.getInitParameter("org.apache.sirona.web.monitored-urls");
        if (!falseStr.equalsIgnoreCase(monitoredUrls)) {
            if (monitoredUrls == null) {
                monitoredUrls = "/*";
            }
            if (ignoredUrls == null) {
                ignoredUrls = Configuration.getProperty((String)"org.apache.sirona.web.ignored-urls", (String)"/sirona");
            }
            if (monitoredUrls.contains(",")) {
                String[] split = monitoredUrls.split(",");
                for (int i = 0; i < split.length; ++i) {
                    FilterRegistration.Dynamic filter = ctx.addFilter("monitoring-filter-" + i, SironaFilter.class);
                    filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{split[i]});
                    filter.setInitParameter("org.apache.sirona.web.monitored-status", monStatus);
                    filter.setInitParameter("org.apache.sirona.web.ignored-urls", ignoredUrls);
                }
            } else {
                FilterRegistration.Dynamic filter = ctx.addFilter("monitoring-filter", SironaFilter.class);
                filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{monitoredUrls});
                filter.setInitParameter("org.apache.sirona.web.monitored-status", monStatus);
                filter.setInitParameter("org.apache.sirona.web.ignored-urls", ignoredUrls);
            }
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(Configuration.getProperty((String)JSP_ACTIVATED, (String)ctx.getInitParameter(JSP_ACTIVATED)))) {
            ctx.addFilter("sirona-jsp-activator", LazyJspMonitoringFilterActivator.class).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"*"});
        }
    }
}

