/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.memory.counter;

import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.Destroying;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.store.BatchFuture;
import org.apache.sirona.store.memory.counter.InMemoryCounterDataStore;
import org.apache.sirona.util.DaemonThreadFactory;

public abstract class BatchCounterDataStore
extends InMemoryCounterDataStore {
    private static final Logger LOGGER = Logger.getLogger(BatchCounterDataStore.class.getName());
    protected final BatchFuture scheduledTask;
    protected final boolean clearAfterCollect;

    protected BatchCounterDataStore() {
        String name = this.getClass().getSimpleName().toLowerCase(Locale.ENGLISH).replace("counterdatastore", "");
        String prefix = "org.apache.sirona." + name;
        long period = this.getPeriod(prefix);
        this.clearAfterCollect = this.isClearAfterCollect(prefix);
        ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory(name + "-counter-schedule-"));
        ScheduledFuture<?> future = ses.scheduleAtFixedRate(new BatchPushCountersTask(), period, period, TimeUnit.MILLISECONDS);
        this.scheduledTask = new BatchFuture(ses, future);
    }

    protected boolean isClearAfterCollect(String prefix) {
        return Configuration.is((String)(prefix + ".counter.clearOnCollect"), (boolean)false);
    }

    protected int getPeriod(String prefix) {
        return Configuration.getInteger((String)(prefix + ".counter.period"), (int)Configuration.getInteger((String)(prefix + ".period"), (int)60000));
    }

    @Destroying
    public void shutdown() {
        this.scheduledTask.done();
    }

    protected void clearCountersIfNeeded() {
        if (this.clearAfterCollect) {
            this.clearCounters();
        }
    }

    protected abstract void pushCountersByBatch(Collection<Counter> var1);

    private class BatchPushCountersTask
    implements Runnable {
        private BatchPushCountersTask() {
        }

        @Override
        public void run() {
            try {
                BatchCounterDataStore.this.pushCountersByBatch(BatchCounterDataStore.this.counters.values());
                BatchCounterDataStore.this.clearCountersIfNeeded();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

