/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.reporting.web.plugin.report;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sirona.Role;
import org.apache.sirona.SironaException;
import org.apache.sirona.counters.AggregatedCounter;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.reporting.web.plugin.api.MapBuilder;
import org.apache.sirona.reporting.web.plugin.api.Regex;
import org.apache.sirona.reporting.web.plugin.api.Template;
import org.apache.sirona.reporting.web.plugin.report.format.Format;
import org.apache.sirona.reporting.web.plugin.report.format.HTMLFormat;
import org.apache.sirona.reporting.web.plugin.report.format.MapFormat;
import org.apache.sirona.repositories.Repository;

public class ReportEndpoints {
    @Regex
    public Template html(HttpServletRequest request, HttpServletResponse response) {
        return this.renderFormat(request, response, Format.Defaults.HTML);
    }

    @Regex(value="/counter/([^/]*)/([^/]*)\\?name=(.*)")
    public Template counterDetail(String role, String unit, String name, HttpServletRequest request) {
        Counter counter = Repository.INSTANCE.getCounter(new Counter.Key(new Role(ReportEndpoints.decode(role), Unit.get((String)unit)), name));
        Map params = request.getParameterMap();
        Unit timeUnit = MapFormat.timeUnit(params);
        String format = MapFormat.format(params, "###,###,###,##0.00");
        TreeMap counters = new TreeMap();
        if (AggregatedCounter.class.isInstance(counter)) {
            for (Map.Entry marker : ((AggregatedCounter)AggregatedCounter.class.cast(counter)).aggregated().entrySet()) {
                counters.put(marker.getKey(), MapFormat.generateLine((Counter)marker.getValue(), timeUnit, format));
            }
        } else {
            counters.put("", MapFormat.generateLine(counter, timeUnit, format));
        }
        return new Template("report/counter.vm", new MapBuilder().set((Object)"headers", (Object)HTMLFormat.ATTRIBUTES_ORDERED_LIST).set((Object)"counter", (Object)counter).set((Object)"counters", counters).build());
    }

    @Regex(value=".csv")
    public Template csv(HttpServletRequest request, HttpServletResponse response) {
        return this.renderFormat(request, response, Format.Defaults.CSV);
    }

    @Regex(value=".json")
    public Template json(HttpServletRequest request, HttpServletResponse response) {
        return this.renderFormat(request, response, Format.Defaults.JSON);
    }

    @Regex(value=".xml")
    public Template xml(HttpServletRequest request, HttpServletResponse response) {
        return this.renderFormat(request, response, Format.Defaults.XML);
    }

    @Regex(value="/clear")
    public void clear(HttpServletRequest request, HttpServletResponse response) {
        Repository.INSTANCE.clearCounters();
        try {
            response.sendRedirect(request.getRequestURI().substring(0, request.getRequestURI().length() - "/clear".length()));
        }
        catch (IOException e) {
            throw new SironaException((Throwable)e);
        }
    }

    private Template renderFormat(HttpServletRequest request, HttpServletResponse response, Format format) {
        response.setContentType(format.type());
        try {
            request.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return format.render(request.getParameterMap());
    }

    private static String decode(String role) {
        try {
            return URLDecoder.decode(role, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

