/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.gauge;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.sirona.Role;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.store.gauge.BatchGaugeDataStoreAdapter;
import org.apache.sirona.store.gauge.GaugeValuesRequest;

public class InMemoryGaugeDataStore
extends BatchGaugeDataStoreAdapter {
    protected final ConcurrentMap<Role, SortedMap<Long, Double>> gauges = new ConcurrentHashMap<Role, SortedMap<Long, Double>>();
    protected final Map<String, Role> roleMapping = new ConcurrentHashMap<String, Role>();

    @Override
    public SortedMap<Long, Double> getGaugeValues(GaugeValuesRequest gaugeValuesRequest) {
        Map map = (Map)this.gauges.get(gaugeValuesRequest.getRole());
        if (map == null) {
            return new TreeMap<Long, Double>();
        }
        HashMap copy = new HashMap(map);
        TreeMap<Long, Double> out = new TreeMap<Long, Double>();
        for (Map.Entry entry : copy.entrySet()) {
            long time = (Long)entry.getKey();
            if (time < gaugeValuesRequest.getStart() || time > gaugeValuesRequest.getEnd()) continue;
            out.put(time, (Double)entry.getValue());
        }
        return out;
    }

    @Override
    public void createOrNoopGauge(Role gauge) {
        this.gauges.putIfAbsent(gauge, new FixedSizedMap());
        this.roleMapping.put(gauge.getName(), gauge);
    }

    @Override
    public void addToGauge(Role role, long time, double value) {
        ((SortedMap)this.gauges.get(role)).put(time, value);
    }

    @Override
    public Collection<Role> gauges() {
        return this.gauges.keySet();
    }

    @Override
    public Role findGaugeRole(String name) {
        return this.roleMapping.get(name);
    }

    @Override
    protected void pushGauges(Map<Role, BatchGaugeDataStoreAdapter.Measure> gauges) {
        for (Map.Entry<Role, BatchGaugeDataStoreAdapter.Measure> entry : gauges.entrySet()) {
            BatchGaugeDataStoreAdapter.Measure value = entry.getValue();
            this.addToGauge(entry.getKey(), value.getTime(), value.getValue());
        }
    }

    @Override
    public void gaugeStopped(Role gauge) {
        super.gaugeStopped(gauge);
        this.roleMapping.remove(gauge.getName());
    }

    protected static class FixedSizedMap
    extends ConcurrentSkipListMap<Long, Double> {
        private static final int MAX_SIZE = Configuration.getInteger("org.apache.sirona.gauge.max-size", 100);

        protected FixedSizedMap() {
        }

        @Override
        public Double put(Long key, Double value) {
            if (this.size() >= MAX_SIZE) {
                this.remove(this.keySet().iterator().next());
            }
            return super.put(key, value);
        }
    }
}

