/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.counters;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Unit
implements Comparable<Unit>,
Serializable {
    private static final Map<String, Unit> UNITS = new ConcurrentHashMap<String, Unit>();
    public static final Unit UNARY = new Unit("u");
    public static final Unit DECA = new Unit("*10", UNARY, 10L);
    public static final Unit HECTO = new Unit("*100", DECA, 10L);
    public static final Unit KILO = new Unit("*1000", HECTO, 10L);
    public static final Unit MEGA = new Unit("*10^6", KILO, 1000L);
    public static final Unit GIGA = new Unit("*10^9", MEGA, 1000L);
    public static final Unit TERA = new Unit("*10^12", GIGA, 1000L);
    private final String name;
    private final long scale;
    private Unit primary;

    public static Unit get(String name) {
        return UNITS.get(name);
    }

    public Unit(String name) {
        this.name = name;
        this.primary = this;
        this.scale = 1L;
        UNITS.put(name, this);
    }

    public Unit(String name, Unit derived, long scale) {
        this.name = name;
        this.primary = derived.isPrimary() ? derived : derived.getPrimary();
        this.scale = scale * derived.getScale();
        UNITS.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public long getScale() {
        return this.scale;
    }

    public double convert(double value, Unit unit) {
        if (unit == this) {
            return value;
        }
        if (!this.isCompatible(unit)) {
            throw new IllegalArgumentException("unit " + this.name + " is incompatible with unit " + unit.name);
        }
        return value * (double)unit.getScale() / (double)this.scale;
    }

    public boolean isPrimary() {
        return this.primary == this;
    }

    public boolean isCompatible(Unit unit) {
        return this.primary == unit.getPrimary();
    }

    public Unit getPrimary() {
        return this.primary;
    }

    @Override
    public int compareTo(Unit o) {
        return this.scale < o.scale ? -1 : 1;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Unit other = (Unit)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static class Binary
    extends Unit {
        public static final Unit BYTE = new Unit("b");
        public static final Unit KBYTE = new Unit("Kb", BYTE, 1024L);
        public static final Unit MBYTE = new Unit("Mb", KBYTE, 1024L);
        public static final Unit GBYTE = new Unit("Gb", MBYTE, 1024L);

        public Binary(String name) {
            super(name);
        }

        public Binary(String name, Unit derived, long scale) {
            super(name, derived, scale);
        }
    }

    public static class Time
    extends Unit {
        public static final Unit NANOSECOND = new Unit("ns");
        public static final Unit MICROSECOND = new Unit("us", NANOSECOND, 1000L);
        public static final Unit MILLISECOND = new Unit("ms", MICROSECOND, 1000L);
        public static final Unit SECOND = new Unit("s", MILLISECOND, 1000L);
        public static final Unit MINUTE = new Unit("min", SECOND, 60L);
        public static final Unit HOUR = new Unit("h", MINUTE, 60L);
        public static final Unit DAY = new Unit("day", HOUR, 24L);

        public Time(String name) {
            super(name);
        }

        public Time(String name, Unit derived, long scale) {
            super(name, derived, scale);
        }
    }
}

