/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.configuration;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sirona.configuration.ConfigurationProvider;
import org.apache.sirona.configuration.FileConfigurationProvider;
import org.apache.sirona.configuration.PropertiesConfigurationProvider;

public final class Configuration {
    private static final Logger LOGGER = Logger.getLogger(Configuration.class.getName());
    public static final String CONFIG_PROPERTY_PREFIX = "org.apache.sirona.";
    private static final String[] DEFAULT_CONFIGURATION_FILES = new String[]{"sirona.properties", "collector-sirona.properties"};
    private static final Properties PROPERTIES = new Properties();

    public static boolean is(String key, boolean defaultValue) {
        return Boolean.parseBoolean(Configuration.getProperty(key, Boolean.toString(defaultValue)));
    }

    public static int getInteger(String key, int defaultValue) {
        return Integer.parseInt(Configuration.getProperty(key, Integer.toString(defaultValue)));
    }

    public static String getProperty(String key, String defaultValue) {
        String property = PROPERTIES.getProperty(key, defaultValue);
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return Configuration.getProperty(property.substring("${".length(), property.length() - 1), defaultValue);
        }
        return property;
    }

    public static String[] getArray(String key, String[] defaultValue) {
        String property = PROPERTIES.getProperty(key);
        if (property == null) {
            return defaultValue;
        }
        return property.split(";");
    }

    private Configuration() {
    }

    static {
        try {
            LinkedList<ConfigurationProvider> providers = new LinkedList<ConfigurationProvider>();
            for (String source : DEFAULT_CONFIGURATION_FILES) {
                providers.add(new FileConfigurationProvider(source));
            }
            providers.add(new PropertiesConfigurationProvider(System.getProperties()));
            for (ConfigurationProvider provider : ServiceLoader.load(ConfigurationProvider.class, Configuration.class.getClassLoader())) {
                providers.add(provider);
            }
            Collections.sort(providers, Sorter.INSTANCE);
            for (ConfigurationProvider provider : providers) {
                PROPERTIES.putAll((Map<?, ?>)provider.configuration());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static class Sorter
    implements Comparator<ConfigurationProvider> {
        public static final Comparator<? super ConfigurationProvider> INSTANCE = new Sorter();

        private Sorter() {
        }

        @Override
        public int compare(ConfigurationProvider o1, ConfigurationProvider o2) {
            return o1.ordinal() - o2.ordinal();
        }
    }
}

