/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.rat.document.IDocument;
import org.apache.rat.document.IDocumentCollection;
import org.apache.rat.document.UnreadableArchiveException;
import org.apache.rat.document.impl.DocumentImplUtils;
import org.apache.rat.document.impl.zip.ZipDocumentFactory;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.RatReportFailedException;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

class ResourceCollectionContainer
implements IReportable {
    private final ResourceCollection rc;

    ResourceCollectionContainer(ResourceCollection rc) {
        this.rc = rc;
    }

    public void run(RatReport report) throws RatReportFailedException {
        ResourceDocument document = new ResourceDocument();
        Iterator iter = this.rc.iterator();
        while (iter.hasNext()) {
            Resource r = (Resource)iter.next();
            if (r.isDirectory()) continue;
            document.setResource(r);
            report.report((IDocument)document);
        }
    }

    private class ResourceDocument
    implements IDocument {
        private Resource resource;

        private ResourceDocument() {
        }

        public Resource getResource() {
            return this.resource;
        }

        public void setResource(Resource resource) {
            this.resource = resource;
        }

        public IDocumentCollection readArchive() throws IOException {
            IDocumentCollection results = null;
            if (!(this.resource instanceof FileResource)) {
                throw new UnreadableArchiveException();
            }
            FileResource fileResource = (FileResource)this.resource;
            File file = fileResource.getFile();
            results = ZipDocumentFactory.load((File)file);
            return results;
        }

        public Reader reader() throws IOException {
            InputStream in = this.resource.getInputStream();
            InputStreamReader result = new InputStreamReader(in);
            return result;
        }

        public String getName() {
            String result = null;
            if (this.resource instanceof FileResource) {
                FileResource fileResource = (FileResource)this.resource;
                File file = fileResource.getFile();
                result = DocumentImplUtils.toName((File)file);
            } else {
                result = this.resource.getName();
            }
            return result;
        }
    }
}

