/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.apache.rat.Defaults;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.util.HeaderMatcherMultiplexer;
import org.apache.rat.anttasks.ResourceCollectionContainer;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReportFailedException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileUtils;

public class Report
extends Task {
    private Union nestedResources;
    private ArrayList licenseMatchers = new ArrayList();
    private ArrayList licenseNames = new ArrayList();
    private boolean addDefaultLicenseMatchers = true;
    private File reportFile;

    public void add(ResourceCollection rc) {
        if (this.nestedResources == null) {
            this.nestedResources = new Union();
        }
        this.nestedResources.add(rc);
    }

    public void add(IHeaderMatcher matcher) {
        this.licenseMatchers.add(matcher);
    }

    public void add(ILicenseFamily license) {
        this.licenseNames.add(license);
    }

    public void setAddDefaultLicenseMatchers(boolean b) {
        this.addDefaultLicenseMatchers = b;
    }

    public void setReportFile(File f) {
        this.reportFile = f;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        this.validate();
        PrintWriter out = null;
        try {
            out = this.reportFile == null ? new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream((Task)this, 2))) : new PrintWriter(new FileWriter(this.reportFile));
            this.createReport(out);
            out.flush();
            if (this.reportFile == null) return;
        }
        catch (IOException ioex) {
            try {
                throw new BuildException((Throwable)ioex);
                catch (TransformerException e) {
                    throw new BuildException((Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new BuildException((Throwable)e);
                }
                catch (RatReportFailedException e) {
                    throw new BuildException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (this.reportFile == null) throw throwable;
                FileUtils.close(out);
                throw throwable;
            }
        }
        FileUtils.close((Writer)out);
    }

    private void validate() {
        if (this.nestedResources == null) {
            throw new BuildException("You must specify at least one file to create the report for.");
        }
        if (!this.addDefaultLicenseMatchers && this.licenseMatchers.size() == 0) {
            throw new BuildException("You must specify at least one license matcher");
        }
    }

    private void createReport(PrintWriter out) throws IOException, TransformerException, InterruptedException, RatReportFailedException {
        HeaderMatcherMultiplexer m = new HeaderMatcherMultiplexer(this.getLicenseMatchers());
        ResourceCollectionContainer rcElement = new ResourceCollectionContainer((ResourceCollection)this.nestedResources);
        org.apache.rat.Report.report((Writer)out, (IReportable)rcElement, (InputStream)Defaults.getDefaultStyleSheet(), (IHeaderMatcher)m, (ILicenseFamily[])this.getApprovedLicenseNames());
    }

    private IHeaderMatcher[] getLicenseMatchers() {
        IHeaderMatcher[] matchers = null;
        if (this.addDefaultLicenseMatchers) {
            int nestedSize = this.licenseMatchers.size();
            if (nestedSize == 0) {
                matchers = Defaults.DEFAULT_MATCHERS;
            } else {
                matchers = new IHeaderMatcher[Defaults.DEFAULT_MATCHERS.length + nestedSize];
                this.licenseMatchers.toArray(matchers);
                System.arraycopy(Defaults.DEFAULT_MATCHERS, 0, matchers, nestedSize, Defaults.DEFAULT_MATCHERS.length);
            }
        } else {
            matchers = this.licenseMatchers.toArray(new IHeaderMatcher[0]);
        }
        return matchers;
    }

    private ILicenseFamily[] getApprovedLicenseNames() {
        ILicenseFamily[] results = null;
        if (this.licenseNames.size() > 0) {
            results = this.licenseNames.toArray(new ILicenseFamily[0]);
        }
        return results;
    }
}

