/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.jms.message.JmsBytesMessage;
import org.apache.qpid.jms.message.JmsMapMessage;
import org.apache.qpid.jms.message.JmsMessage;
import org.apache.qpid.jms.message.JmsObjectMessage;
import org.apache.qpid.jms.message.JmsStreamMessage;
import org.apache.qpid.jms.message.JmsTextMessage;
import org.apache.qpid.jms.provider.amqp.AmqpConsumer;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsBytesMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMapMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsObjectMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsStreamMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpJmsTextMessageFacade;
import org.apache.qpid.jms.provider.amqp.message.AmqpMessageSupport;
import org.apache.qpid.jms.util.ContentTypeSupport;
import org.apache.qpid.jms.util.InvalidContentTypeException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class AmqpJmsMessageBuilder {
    public static JmsMessage createJmsMessage(AmqpConsumer consumer, ByteBuf messageBytes) throws IOException {
        Message amqpMessage = AmqpMessageSupport.decodeMessage(messageBytes);
        JmsMessage result = AmqpJmsMessageBuilder.createFromMsgAnnotation(consumer, amqpMessage, messageBytes);
        if (result != null) {
            return result;
        }
        result = AmqpJmsMessageBuilder.createWithoutAnnotation(consumer, amqpMessage, messageBytes);
        if (result != null) {
            return result;
        }
        throw new IOException("Could not create a JMS message from incoming message");
    }

    private static JmsMessage createFromMsgAnnotation(AmqpConsumer consumer, Message message, ByteBuf messageBytes) throws IOException {
        Object annotation = AmqpMessageSupport.getMessageAnnotation("x-opt-jms-msg-type", message);
        if (annotation != null) {
            switch ((Byte)annotation) {
                case 0: {
                    return AmqpJmsMessageBuilder.createMessage(consumer, message);
                }
                case 3: {
                    return AmqpJmsMessageBuilder.createBytesMessage(consumer, message);
                }
                case 5: {
                    return AmqpJmsMessageBuilder.createTextMessage(consumer, message, StandardCharsets.UTF_8);
                }
                case 2: {
                    return AmqpJmsMessageBuilder.createMapMessage(consumer, message);
                }
                case 4: {
                    return AmqpJmsMessageBuilder.createStreamMessage(consumer, message);
                }
                case 1: {
                    return AmqpJmsMessageBuilder.createObjectMessage(consumer, message, messageBytes);
                }
            }
            throw new IOException("Invalid JMS Message Type annotation value found in message: " + annotation);
        }
        return null;
    }

    private static JmsMessage createWithoutAnnotation(AmqpConsumer consumer, Message message, ByteBuf messageBytes) {
        Section body = message.getBody();
        if (body == null) {
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                return AmqpJmsMessageBuilder.createObjectMessage(consumer, message, messageBytes);
            }
            if (AmqpMessageSupport.isContentType("application/octet-stream", message) || AmqpMessageSupport.isContentType(null, message)) {
                return AmqpJmsMessageBuilder.createBytesMessage(consumer, message);
            }
            Charset charset = AmqpJmsMessageBuilder.getCharsetForTextualContent(message.getContentType());
            if (charset != null) {
                return AmqpJmsMessageBuilder.createTextMessage(consumer, message, charset);
            }
            return AmqpJmsMessageBuilder.createMessage(consumer, message);
        }
        if (body instanceof Data) {
            if (AmqpMessageSupport.isContentType("application/octet-stream", message) || AmqpMessageSupport.isContentType(null, message)) {
                return AmqpJmsMessageBuilder.createBytesMessage(consumer, message);
            }
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                return AmqpJmsMessageBuilder.createObjectMessage(consumer, message, messageBytes);
            }
            Charset charset = AmqpJmsMessageBuilder.getCharsetForTextualContent(message.getContentType());
            if (charset != null) {
                return AmqpJmsMessageBuilder.createTextMessage(consumer, message, charset);
            }
            return AmqpJmsMessageBuilder.createBytesMessage(consumer, message);
        }
        if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                return AmqpJmsMessageBuilder.createTextMessage(consumer, message, StandardCharsets.UTF_8);
            }
            if (value instanceof Binary) {
                return AmqpJmsMessageBuilder.createBytesMessage(consumer, message);
            }
            return AmqpJmsMessageBuilder.createObjectMessage(consumer, message, messageBytes);
        }
        if (body instanceof AmqpSequence) {
            return AmqpJmsMessageBuilder.createObjectMessage(consumer, message, messageBytes);
        }
        return null;
    }

    private static JmsObjectMessage createObjectMessage(AmqpConsumer consumer, Message message, ByteBuf messageBytes) {
        return new JmsObjectMessage(new AmqpJmsObjectMessageFacade(consumer, message, messageBytes.copy()));
    }

    private static JmsStreamMessage createStreamMessage(AmqpConsumer consumer, Message message) {
        return new JmsStreamMessage(new AmqpJmsStreamMessageFacade(consumer, message));
    }

    private static JmsMapMessage createMapMessage(AmqpConsumer consumer, Message message) {
        return new JmsMapMessage(new AmqpJmsMapMessageFacade(consumer, message));
    }

    private static JmsTextMessage createTextMessage(AmqpConsumer consumer, Message message, Charset charset) {
        return new JmsTextMessage(new AmqpJmsTextMessageFacade(consumer, message, charset));
    }

    private static JmsBytesMessage createBytesMessage(AmqpConsumer consumer, Message message) {
        return new JmsBytesMessage(new AmqpJmsBytesMessageFacade(consumer, message));
    }

    private static JmsMessage createMessage(AmqpConsumer consumer, Message message) {
        return new JmsMessage(new AmqpJmsMessageFacade(consumer, message));
    }

    private static Charset getCharsetForTextualContent(String contentType) {
        try {
            return ContentTypeSupport.parseContentTypeForTextualCharset(contentType);
        }
        catch (InvalidContentTypeException e) {
            return null;
        }
    }
}

