/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp.builders;

import java.util.LinkedHashMap;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsSessionInfo;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.amqp.AmqpConnection;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpSession;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.amqp.builders.AmqpConnectionSessionBuilder;
import org.apache.qpid.jms.provider.amqp.builders.AmqpResourceBuilder;
import org.apache.qpid.jms.util.MetaDataSupport;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.engine.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpConnectionBuilder
extends AmqpResourceBuilder<AmqpConnection, AmqpProvider, JmsConnectionInfo, Connection> {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpConnectionBuilder.class);

    public AmqpConnectionBuilder(AmqpProvider parent, JmsConnectionInfo resourceInfo) {
        super(parent, resourceInfo);
    }

    @Override
    public void buildResource(final AsyncResult request) {
        AsyncResult connectionRequest = new AsyncResult(){

            @Override
            public void onSuccess() {
                JmsSessionInfo sessionInfo = new JmsSessionInfo((JmsConnectionInfo)AmqpConnectionBuilder.this.getResourceInfo(), -1L);
                sessionInfo.setAcknowledgementMode(1);
                final AmqpConnectionSessionBuilder builder = new AmqpConnectionSessionBuilder((AmqpConnection)AmqpConnectionBuilder.this.getResource(), sessionInfo);
                builder.buildResource(new AsyncResult(){

                    @Override
                    public boolean isComplete() {
                        return ((AmqpSession)builder.getResource()).isOpen();
                    }

                    @Override
                    public void onSuccess() {
                        LOG.debug("{} is now open: ", AmqpConnectionBuilder.this.getResource());
                        request.onSuccess();
                    }

                    @Override
                    public void onFailure(Throwable result) {
                        LOG.debug("AMQP Connection Session failed to open.");
                        request.onFailure(result);
                    }
                });
            }

            @Override
            public void onFailure(Throwable result) {
                request.onFailure(result);
            }

            @Override
            public boolean isComplete() {
                return ((AmqpConnection)AmqpConnectionBuilder.this.getResource()).isOpen();
            }
        };
        super.buildResource(connectionRequest);
    }

    @Override
    protected Connection createEndpoint(JmsConnectionInfo resourceInfo) {
        String hostname = ((AmqpProvider)this.getParent()).getVhost();
        if (hostname == null) {
            hostname = ((AmqpProvider)this.getParent()).getRemoteURI().getHost();
        } else if (hostname.isEmpty()) {
            hostname = null;
        }
        LinkedHashMap<Symbol, String> props = new LinkedHashMap<Symbol, String>();
        props.put(AmqpSupport.PRODUCT, "QpidJMS");
        props.put(AmqpSupport.VERSION, MetaDataSupport.PROVIDER_VERSION);
        props.put(AmqpSupport.PLATFORM, MetaDataSupport.PLATFORM_DETAILS);
        Connection connection = ((AmqpProvider)this.getParent()).getProtonConnection();
        connection.setHostname(hostname);
        connection.setContainer(resourceInfo.getClientId());
        connection.setDesiredCapabilities(new Symbol[]{AmqpSupport.SOLE_CONNECTION_CAPABILITY});
        connection.setProperties(props);
        return connection;
    }

    @Override
    protected AmqpConnection createResource(AmqpProvider parent, JmsConnectionInfo resourceInfo, Connection endpoint) {
        return new AmqpConnection(parent, resourceInfo, endpoint);
    }

    @Override
    protected void afterOpened() {
        ((AmqpConnection)this.getResource()).getProperties().initialize(((Connection)this.getEndpoint()).getRemoteOfferedCapabilities(), ((Connection)this.getEndpoint()).getRemoteProperties());
    }

    @Override
    protected boolean isClosePending() {
        return ((AmqpConnection)this.getResource()).getProperties().isConnectionOpenFailed();
    }

    @Override
    protected long getRequestTimeout() {
        return ((AmqpProvider)this.getParent()).getProvider().getConnectTimeout();
    }
}

