/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.WeakHashMap;
import javax.jms.JMSException;
import org.apache.qpid.amqp_1_0.jms.Destination;
import org.apache.qpid.amqp_1_0.jms.Queue;
import org.apache.qpid.amqp_1_0.jms.Topic;

public class DestinationImpl
implements Destination,
Queue,
Topic {
    private static final WeakHashMap<String, DestinationImpl> DESTINATION_CACHE = new WeakHashMap();
    private final String _address;

    protected DestinationImpl(String address) {
        this._address = address;
    }

    @Override
    public String getAddress() {
        return this._address;
    }

    public static DestinationImpl valueOf(String address) {
        return address == null ? null : DestinationImpl.createDestination(address);
    }

    public int hashCode() {
        return this._address.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this._address.equals(((DestinationImpl)obj)._address);
    }

    public static synchronized DestinationImpl createDestination(String address) {
        DestinationImpl destination = DESTINATION_CACHE.get(address);
        if (destination == null) {
            destination = new DestinationImpl(address);
            DESTINATION_CACHE.put(address, destination);
        }
        return destination;
    }

    public String getQueueName() throws JMSException {
        return this.getAddress();
    }

    public String getTopicName() throws JMSException {
        return this.getAddress();
    }
}

